package org.bidib.wizard.dialog;

import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class NodeLabelPanel {

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";

    private JPanel contentPanel;

    private NodeLabelModel nodeLabelModel;

    private ValueModel nodeNameValueModel;

    private ValueModel productNameValueModel;

    private ValueModel uuidValueModel;

    private JButton applyButton;

    private JButton cancelButton;

    public NodeLabelPanel() {
    }

    /**
     * @param nodeLabelModel
     *            the nodeLabelModel to set
     */
    public void setNodeLabelModel(NodeLabelModel nodeLabelModel) {
        this.nodeLabelModel = nodeLabelModel;
    }

    public JPanel createPanel() {

        boolean debug = false;
        FormBuilder builder =
            FormBuilder
                .create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows("p, 3dlu, p, 3dlu, p, 3dlu, p")
                .panel(debug ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.DIALOG);

        nodeNameValueModel =
            new PropertyAdapter<NodeLabelModel>(nodeLabelModel, NodeLabelModel.PROPERTYNAME_NODE_NAME, true);
        JTextField nodeNameText = WizardComponentFactory.createTextField(nodeNameValueModel, false);
        nodeNameText.setEditable(true);
        builder.add(Resources.getString(getClass(), "nodeName")).xy(1, 1);
        builder.add(nodeNameText).xyw(3, 1, 3);

        productNameValueModel =
            new PropertyAdapter<NodeLabelModel>(nodeLabelModel, NodeLabelModel.PROPERTYNAME_PRODUCT_NAME, true);
        JTextField productNameText = WizardComponentFactory.createTextField(productNameValueModel, true);
        productNameText.setEditable(false);
        builder.add(Resources.getString(getClass(), "productName")).xy(1, 3);
        builder.add(productNameText).xyw(3, 3, 3);

        uuidValueModel = new PropertyAdapter<NodeLabelModel>(nodeLabelModel, NodeLabelModel.PROPERTYNAME_UID, true);
        JTextField uuidText = WizardComponentFactory.createTextField(uuidValueModel, true);
        uuidText.setEditable(false);
        builder.add(Resources.getString(getClass(), "uid")).xy(1, 5);
        builder.add(uuidText).xyw(3, 5, 3);

        // prepare the close button
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(applyButton, cancelButton).build();
        builder.add(buttons).xyw(1, 7, 5);

        contentPanel = builder.build();
        return contentPanel;
    }

    public Dimension getPreferredSize() {
        Dimension pref = contentPanel.getPreferredSize();
        if (pref.width < 300) {
            pref.width = 300;
        }
        return pref;
    }

    public void setApplyButton(JButton applyButton) {
        this.applyButton = applyButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }
}
