package org.bidib.wizard.mvc.accessory.controller.listener;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.model.NodeInterface;

public interface AccessoryControllerListener {

    /**
     * Send the accessory request.
     * 
     * @param node
     *            the BiDiB node
     * @param dccAddress
     *            the DCC address to switch
     * @param aspect
     *            the aspect to set
     * @param switchTime
     *            the switch time
     * @param timeBaseUnit
     *            the time base unit (100ms or 1s)
     * @param timingControl
     *            the timing control
     * @return the accessory acknowledge
     */
    AccessoryAcknowledge sendAccessoryRequest(
        final NodeInterface node, AddressData dccAddress, Integer aspect, Integer switchTime,
        TimeBaseUnitEnum timeBaseUnit, TimingControlEnum timingControl);
}
