package org.bidib.wizard.mvc.backup.model;

import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;

import com.jgoodies.binding.beans.Model;

public class NodeBackupModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_BOOSTER_LABEL = "nodeLabel";

    public static final String PROPERTY_PROGRESS = "progress";

    private final NodeInterface node;

    private String nodeLabel;

    private boolean selected;

    private int progress = 0;

    private final WizardLabelWrapper wizardLabelWrapper;

    public NodeBackupModel(final NodeInterface node, final WizardLabelWrapper wizardLabelWrapper) {
        this.node = node;
        this.wizardLabelWrapper = wizardLabelWrapper;
    }

    public NodeInterface getNode() {
        return this.node;
    }

    /**
     * @param nodeLabel
     *            the node label to set
     */
    public void setNodeLabel(String nodeLabel) {
        String oldValue = this.nodeLabel;

        this.nodeLabel = nodeLabel;

        firePropertyChange(PROPERTY_BOOSTER_LABEL, oldValue, this.nodeLabel);
    }

    /**
     * @return the node label
     */
    public String getNodeLabel() {

        final NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(node.getUniqueId());

        BidibNodeNameUtils.NodeLabelData labelData = BidibNodeNameUtils.prepareLabel(node, nodeLabels, false, true);
        String userName = labelData.getNodeLabel();
        if (StringUtils.isNotBlank(userName)) {
            return userName;
        }

        return nodeLabel;
    }

    /**
     * @return the selected flag
     */
    public boolean isSelected() {
        return selected;
    }

    /**
     * @param selected
     *            the selected flag
     */
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    /**
     * @return the progress
     */
    public int getProgress() {
        return progress;
    }

    /**
     * @param progress
     *            the progress to set
     */
    public void setProgress(int progress) {
        int oldValue = this.progress;
        this.progress = progress;

        firePropertyChange(PROPERTY_PROGRESS, oldValue, this.progress);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NodeBackupModel) {
            NodeBackupModel other = (NodeBackupModel) obj;
            if (node.equals(other.getNode())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return node.hashCode();
    }

}
