package org.bidib.wizard.mvc.backup.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import javax.swing.SwingConstants;

import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.ProgressCellRenderer;
import org.bidib.wizard.mvc.backup.model.NodeBackupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.CellPainter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.HeaderStyleModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.icons.CheckBoxIcon;
import com.jidesoft.swing.JideSwingUtilities;

public class BackupTableTableModel extends AbstractTableAdapter<NodeBackupModel>
    implements ContextSensitiveTableModel, HeaderStyleModel, StyleModel {

    private static final Logger LOGGER = LoggerFactory.getLogger(BackupTableTableModel.class);

    private static final long serialVersionUID = 1L;

    public static final int COLUMN_SELECTED = 0;

    public static final int COLUMN_UNIQUE_ID = 1;

    public static final int COLUMN_DESCRIPTION = 2;

    public static final int COLUMN_PROGRESS = 3;

    private static final String[] COLUMNNAMES =
        new String[] { Resources.getString(BackupTableTableModel.class, "selected"),
            Resources.getString(BackupTableTableModel.class, "uniqueId"),
            Resources.getString(BackupTableTableModel.class, "description"),
            Resources.getString(BackupTableTableModel.class, "progress") };

    private final CellStyle ICON_STYLE = new CellStyle();

    private final CellStyle CELL_STYLE_UNDERLAY = new CellStyle();

    public BackupTableTableModel(SelectionInList<NodeBackupModel> nodeBackupList) {
        super(nodeBackupList, COLUMNNAMES);

        ICON_STYLE.setHorizontalAlignment(SwingConstants.CENTER);
        ICON_STYLE.setVerticalAlignment(SwingConstants.CENTER);
        ICON_STYLE.setIcon(new CheckBoxIcon());
        ICON_STYLE.setText("");

        // TODO currently not used
        CELL_STYLE_UNDERLAY.setUnderlayCellPainter(new CellPainter() {
            @Override
            public void paint(Graphics g, Component component, int row, int column, Rectangle cellRect, Object value) {
                if (value instanceof Double) {
                    Graphics2D g2d = (Graphics2D) g.create();
                    double dv = (Double) value;
                    Rectangle clip =
                        new Rectangle(cellRect.x, cellRect.y, (int) (cellRect.width * dv / 100.0), cellRect.height);
                    g2d.clip(clip);
                    if (dv > 66.0) {
                        JideSwingUtilities
                            .fillGradient(g2d, cellRect, new Color(147, 98, 184), new Color(229, 193, 255), false);
                    }
                    else if (dv > 33.0) {
                        JideSwingUtilities
                            .fillGradient(g2d, cellRect, new Color(173, 135, 24), new Color(246, 218, 135), false);
                    }
                    else {
                        JideSwingUtilities
                            .fillGradient(g2d, cellRect, new Color(75, 126, 176), new Color(170, 208, 246), false);
                    }
                    g2d.dispose();
                }
                else if (value instanceof Integer) {
                    Graphics2D g2d = (Graphics2D) g.create();
                    int dv = (Integer) value;
                    Rectangle clip =
                        new Rectangle(cellRect.x, cellRect.y, (int) (cellRect.width * dv / 100.0), cellRect.height);
                    g2d.clip(clip);
                    if (dv > 66.0) {
                        JideSwingUtilities
                            .fillGradient(g2d, cellRect, new Color(147, 98, 184), new Color(229, 193, 255), false);
                    }
                    else if (dv > 33.0) {
                        JideSwingUtilities
                            .fillGradient(g2d, cellRect, new Color(173, 135, 24), new Color(246, 218, 135), false);
                    }
                    else {
                        JideSwingUtilities
                            .fillGradient(g2d, cellRect, new Color(75, 126, 176), new Color(170, 208, 246), false);
                    }
                    g2d.dispose();
                }
            }
        });

        LOGGER.info("Current listModel: {}", getListModel());
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case COLUMN_UNIQUE_ID:
                return String.class;
            case COLUMN_SELECTED:
                return Boolean.class;
            case COLUMN_PROGRESS:
                return Integer.class;
            default:
                return Object.class;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == COLUMN_SELECTED) {
            return true;
        }
        return false;
    }

    @Override
    public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
        EditorContext editorContext = null;
        switch (columnIndex) {
            case COLUMN_SELECTED:
                editorContext = BooleanCheckBoxCellEditor.CONTEXT;
                break;
            case COLUMN_PROGRESS:
                editorContext = ProgressCellRenderer.CONTEXT;
                break;
            default:
                break;
        }

        return editorContext;
    }

    @Override
    public Class<?> getCellClassAt(int rowIndex, int columnIndex) {
        return getColumnClass(columnIndex);
    }

    @Override
    public CellStyle getHeaderStyleAt(int rowIndex, int columnIndex) {

        return columnIndex == 0 ? ICON_STYLE : null;
    }

    @Override
    public boolean isHeaderStyleOn() {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {

        // prevent NPE because of AbstractTableAdapter
        if (rowIndex >= getRowCount()) {
            return null;
        }

        NodeBackupModel nodeBackup = getRow(rowIndex);
        switch (columnIndex) {
            case COLUMN_UNIQUE_ID:
                return ByteUtils.getUniqueIdAsString(nodeBackup.getNode().getUniqueId());
            case COLUMN_DESCRIPTION:
                return nodeBackup.getNodeLabel();
            case COLUMN_SELECTED:
                return nodeBackup.isSelected();
            case COLUMN_PROGRESS:
                return Integer.valueOf(nodeBackup.getProgress());
            default:
                return null;
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        NodeBackupModel nodeBackup = getRow(rowIndex);
        switch (columnIndex) {
            case COLUMN_SELECTED:
                Boolean selected = value != null ? ((Boolean) value).booleanValue() : false;
                nodeBackup.setSelected(selected);
                break;
            default:
                break;
        }

        super.setValueAt(value, rowIndex, columnIndex);
    }

    @Override
    public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
        // if (columnIndex == COLUMN_PROGRESS) {
        // return CELL_STYLE_UNDERLAY;
        // }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return true;
    }

}
