package org.bidib.wizard.mvc.booster.view;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.mvc.booster.controller.listener.BoosterTableControllerListener;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.bidib.wizard.mvc.booster.model.BoosterTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TablePopupMenuInstaller;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;

public class BoosterTableView implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableView.class);

    private final JPanel contentPanel;

    private SelectionInList<BoosterModel> boosterSelection;

    public BoosterTableView(final BoosterTableControllerListener boosterTableController,
        final BoosterTableModel boosterTableModel) {

        DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.setName(Resources.getString(getClass(), "title"));
        DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.setAutoHideEnabled(false);

        LOGGER.info("Create new BoosterTableView");

        contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());

        boosterSelection =
            new SelectionInList<BoosterModel>((ListModel<BoosterModel>) boosterTableModel.getBoosterListModel());

        final TableModel tableModel = new SortableTableModel(new BoosterTableTableModel(boosterSelection));

        // create a booster table
        final AbstractEmptyTable boosterTable =
            new AbstractEmptyTable(tableModel, Resources.getString(getClass(), "empty_table")) {
                private static final long serialVersionUID = 1L;
            };
        boosterTable.adjustRowHeight();
        boosterTable.setSelectionModel(new SingleListSelectionAdapter(boosterSelection.getSelectionIndexHolder()));
        // boosterTable.setSortable(true);

        TableColumn tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_UNIQUE_ID);
        tc.setMinWidth(120);
        tc.setMaxWidth(150);
        tc.setPreferredWidth(150);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_DESCRIPTION);
        tc.setPreferredWidth(300);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_STATUS);
        tc.setCellRenderer(new BoosterStateCellRenderer());
        tc.setMaxWidth(60);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_CS_STATUS);
        tc.setCellRenderer(new CommandStationStateCellRenderer());
        tc.setMaxWidth(60);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_TEMPERATURE);
        tc.setCellRenderer(new TemperatureCellRenderer());
        tc.setMaxWidth(60);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_VOLTAGE);
        tc.setCellRenderer(new VoltageCellRenderer());
        tc.setMaxWidth(60);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_MAX_CURRENT);
        tc.setCellRenderer(new CurrentCellRenderer());
        tc.setMaxWidth(100);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_CURRENT);
        tc.setCellRenderer(new CurrentCellRenderer());
        tc.setMaxWidth(70);
        tc = boosterTable.getColumnModel().getColumn(BoosterTableTableModel.COLUMN_CONTROL);
        tc.setCellRenderer(new BoosterControlCellRenderer());

        final DefaultOverlayable overlayTable = new DefaultOverlayable(new JScrollPane(boosterTable));
        tableModel.addTableModelListener(new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(tableModel.getRowCount() == 0);
            }
        });

        overlayTable
            .addOverlayComponent(
                StyledLabelBuilder.createStyledLabel("{" + boosterTable.getEmptyTableText() + ":f:gray}"));

        contentPanel.add(overlayTable, BorderLayout.CENTER);

        final JPopupMenu boosterTableMenu =
            new BoosterTableMenu(contentPanel, boosterTableController, boosterSelection);

        TablePopupMenuInstaller installer = new TablePopupMenuInstaller(boosterTable) {
            @Override
            protected JPopupMenu createPopupMenu() {
                return boosterTableMenu;
            }

            @Override
            protected void customizeMenuItems(JTable table, JPopupMenu popup, int clickingRow, int clickingColumn) {
                LOGGER.info("Customize the popup menu: {}", popup);

                if (clickingRow > -1 && table.getSelectedRow() != clickingRow) {
                    table.setRowSelectionInterval(clickingRow, clickingRow);
                }

                // only allow booster on if node has is booster
                if (popup instanceof BoosterTableMenu) {
                    final BoosterTableMenu boosterTableMenu = (BoosterTableMenu) popup;
                    final BoosterState boosterState =
                        (BoosterState) table.getValueAt(clickingRow, BoosterTableTableModel.COLUMN_STATUS);
                    final CommandStationState csState =
                        (CommandStationState) table.getValueAt(clickingRow, BoosterTableTableModel.COLUMN_CS_STATUS);

                    BoosterModel booster = null;
                    TableModel tm = table.getModel();
                    if (tm instanceof SortableTableModel) {
                        SortableTableModel stm = (SortableTableModel) tm;

                        // final BoosterTableTableModel servoTableModel = (BoosterTableTableModel) stm.getActualModel();

                        booster =
                            (BoosterModel) stm.getValueAt(clickingRow, BoosterTableTableModel.COLUMN_PORT_INSTANCE);

                    }

                    boosterTableMenu.prepareMenuItems(booster, boosterState, csState);
                }
                super.customizeMenuItems(table, popup, clickingRow, clickingColumn);
            }
        };
    }

    // /**
    // * @return the last column must be packed after all rows are added.
    // */
    // protected boolean isPackLastColumn() {
    // return true;
    // }

    @Override
    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW;
    }

    @Override
    public Component getComponent() {
        return contentPanel;
    }
}
