package org.bidib.wizard.mvc.common.view.converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.value.BindingConverter;

public class StringToLocalTimeConverter implements BindingConverter<LocalTime, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToLocalTimeConverter.class);

    @Override
    public String targetValue(LocalTime sourceValue) {

        if (sourceValue != null) {
            return DateTimeFormatter.ofPattern("HH:mm").format(sourceValue);
        }
        return null;
    }

    @Override
    public LocalTime sourceValue(String targetValue) {

        if (StringUtils.isNotBlank(targetValue)) {
            try {
                return LocalTime.parse(targetValue, DateTimeFormatter.ofPattern("HH:mm"));
            }
            catch (Exception ex) {
                LOGGER.warn("Parse string to LocalTime failed, value: {}, message: {}", targetValue, ex.getMessage());
            }
        }
        return null;
    }

}
