package org.bidib.wizard.mvc.common.view.converter;

import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.value.BindingConverter;

public class StringToProtocolVersionConverter implements BindingConverter<ProtocolVersion, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToProtocolVersionConverter.class);

    @Override
    public String targetValue(ProtocolVersion sourceValue) {

        if (sourceValue != null) {
            return sourceValue.toString();
        }
        return null;
    }

    @Override
    public ProtocolVersion sourceValue(String targetValue) {

        if (StringUtils.isNotBlank(targetValue)) {
            try {
                ProtocolVersion.parse(targetValue);
            }
            catch (Exception ex) {
                LOGGER
                    .warn("Parse string to ProtocolVersion failed, value: {}, message: {}", targetValue,
                        ex.getMessage());
            }
        }
        return null;
    }

}
