package org.bidib.wizard.mvc.common.view.editor;

import java.awt.Component;

import javax.swing.JTable;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxChannelCellEditor extends NumberRangeEditor {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(DmxChannelCellEditor.class);

    private static final int DMX_MAPPING_OFFSET = 1;

    public DmxChannelCellEditor(int minimum, int maximum) {
        super(minimum, maximum);
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (StringUtils.isNotBlank(textField.getText())) {
                int value = Integer.parseInt(textField.getText());

                return Integer.max(value - DMX_MAPPING_OFFSET, 0);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse textfield value failed.", ex);
        }
        return Integer.valueOf(0);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {

        if (value instanceof Integer) {
            Integer integerValue = (Integer) value;
            textField.setText(Integer.toString(integerValue.intValue() + DMX_MAPPING_OFFSET));
        }
        else {
            textField.setText(value != null ? value.toString() : "");
        }
        return textField;
    }

}
