package org.bidib.wizard.mvc.common.view.table;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

@Deprecated
public class LineNumberTableRowHeader extends JComponent {

    private static final long serialVersionUID = 1L;

    private final JTable table;

    private final JScrollPane scrollPane;

    private int verticalOffset;

    private int rowOffset;

    public LineNumberTableRowHeader(JScrollPane jScrollPane, JTable table) {
        this.scrollPane = jScrollPane;
        this.table = table;
        this.table.getModel().addTableModelListener(new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent tme) {
                LineNumberTableRowHeader.this.repaint();
            }
        });

        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent lse) {
                LineNumberTableRowHeader.this.repaint();
            }
        });

        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener() {
            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                LineNumberTableRowHeader.this.repaint();
            }
        });

        setPreferredSize(new Dimension(50, 90));
    }

    /**
     * @return the verticalOffset
     */
    public int getVerticalOffset() {
        return verticalOffset;
    }

    /**
     * @param verticalOffset
     *            the verticalOffset to set
     */
    public void setVerticalOffset(int verticalOffset) {
        this.verticalOffset = verticalOffset;
    }

    /**
     * @return the rowOffset
     */
    public int getRowOffset() {
        return rowOffset;
    }

    /**
     * @param rowOffset
     *            the rowOffset to set
     */
    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Point viewPosition = scrollPane.getViewport().getViewPosition();
        Dimension viewSize = scrollPane.getViewport().getViewSize();
        if (getHeight() < viewSize.height) {
            Dimension size = getPreferredSize();
            size.height = viewSize.height;
            setSize(size);
            setPreferredSize(size);
        }

        super.paintComponent(g);

        g.setColor(getBackground());
        g.fillRect(0, 0, getWidth(), getHeight());

        FontMetrics fm = g.getFontMetrics();

        int totalRowCount = table.getRowCount();

        for (int rowNumber = 0; rowNumber < totalRowCount; rowNumber++) {
            Rectangle cellRect = table.getCellRect(rowNumber, 0, false);

            boolean rowSelected = table.isRowSelected(rowNumber);

            if (rowSelected) {
                g.setColor(table.getSelectionBackground());
                g.fillRect(0, cellRect.y, getWidth(), cellRect.height);
            }

            if ((cellRect.y + cellRect.height) - viewPosition.y >= 0 && cellRect.y < viewPosition.y + viewSize.height) {
                g.setColor(table.getGridColor());
                g.drawLine(0, cellRect.y + cellRect.height, getWidth(), cellRect.y + cellRect.height);
                g.setColor(rowSelected ? table.getSelectionForeground() : getForeground());
                String s = prepareRowString(rowNumber + rowOffset, totalRowCount);
                g
                    .drawString(s, getWidth() - fm.stringWidth(s) - 2,
                        cellRect.y + cellRect.height - fm.getDescent() - verticalOffset);
            }
        }

        if (table.getShowVerticalLines()) {
            g.setColor(table.getGridColor());
            g.drawRect(0, 0, getWidth() - 1, getHeight() - 1);
        }
    }

    protected String prepareRowString(int rowNumber, int totalRowCount) {
        String s = Integer.toString(rowNumber + rowOffset);
        return s;
    }
}
