package org.bidib.wizard.mvc.common.view.text;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextFieldLimitDocument extends PlainDocument {

    private static final long serialVersionUID = 1L;

    private int limit;

    public JTextFieldLimitDocument(int limit) {
        super();
        this.limit = limit;
    }

    public JTextFieldLimitDocument(int limit, boolean upper) {
        super();
        this.limit = limit;
    }

    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null)
            return;
        if ((getLength() + str.length()) <= limit) {
            super.insertString(offset, str, attr);
        }
    }

}
