package org.bidib.wizard.mvc.loco.view;

import java.awt.Color;

import javax.swing.BorderFactory;

import eu.hansolo.steelseries.tools.Section;

public class SpeedGaugeBuilder {

    public static SpeedGaugeBinding speedGauge(String title, String unitString) {

        final SpeedGaugeBinding gauge = new SpeedGaugeBinding();

        gauge.setTitle(title);
        gauge.setUnitString(unitString);
        gauge.setNiceScale(false);
        gauge.setMaxValue(127);

        gauge.setThreshold(120);

        Section[] sections = new Section[3];

        sections[0] = new Section(0, 90, Color.GREEN.darker());
        sections[1] = new Section(90, 120, Color.ORANGE);
        sections[2] = new Section(120, gauge.getMaxValue(), Color.RED);
        gauge.setSections(sections);
        gauge.setSectionsVisible(true);

        gauge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gauge.setFrameVisible(false);

        return gauge;
    }

}
