package org.bidib.wizard.mvc.loco.view.speedo;

import java.awt.Frame;
import java.awt.Window;
import java.text.DecimalFormat;

import javax.swing.Icon;
import javax.swing.JOptionPane;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.LabeledTextField;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.TaskDialog.Command;
import org.oxbow.swingbits.dialog.task.TaskDialog.StandardCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;

public class ApproveScaleDialog {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApproveScaleDialog.class);

    private final SpeedScaleBeanModel speedScaleBeanModel;

    private int result = JOptionPane.CANCEL_OPTION;

    public ApproveScaleDialog(Frame frame, final SpeedScaleBeanModel speedScaleBeanModel) {

        this.speedScaleBeanModel = speedScaleBeanModel;

        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            formBuilder =
                FormBuilder
                    .create().columns("pref, 3dlu, pref, 2dlu, pref:grow").rows("pref").panel(new FormDebugPanel());
        }
        else {
            formBuilder = FormBuilder.create().columns("pref, 3dlu, pref, 2dlu, pref:grow").rows("pref");
        }

        ValueModel scaleValueModel =
            new PropertyAdapter<SpeedScaleBeanModel>(this.speedScaleBeanModel,
                SpeedScaleBeanModel.PROPERTYNAME_CV37_SCALE, true);

        final ValueModel scaleConverterModel =
            new ConverterValueModel(scaleValueModel, new StringConverter(new DecimalFormat("#")));

        LabeledTextField scale = WizardComponentFactory.createLabeledTextField(scaleConverterModel, false, "1:", null);

        formBuilder.add(Resources.getString(getClass(), "scale")).xy(1, 1);
        formBuilder.add(scale).xy(3, 1);

        // prepare the dialog
        TaskDialog dlg =
            questionDialog(frame, Resources.getString(getClass(), "title"), TaskDialog.StandardIcon.QUESTION,
                Resources.getString(getClass(), "instruction"), Resources.getString(getClass(), "message"));

        dlg.setFixedComponent(formBuilder.build());

        // if the model is valid, the write button is enabled.
        // Command okCommand = dlg.getCommands().toArray(new Command[0])[0];

        Command result = dlg.show();
        LOGGER.info("Result of validate scale dialog: {}", result.equals(StandardCommand.OK));

        if (result.equals(StandardCommand.OK)) {
            fireContinue();
        }
        else {
            fireCancel();
        }
    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");

        result = JOptionPane.YES_OPTION;
    }

    private void fireCancel() {

    }

    public int getResult() {
        return result;
    }

    public SpeedScaleBeanModel getSpeedScaleBeanModel() {
        return speedScaleBeanModel;
    }

    private static TaskDialog questionDialog(Window parent, String title, Icon icon, String instruction, String text) {

        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(instruction);
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg
            .setCommands(StandardCommand.OK.derive(Resources.getString(ApproveScaleDialog.class, "update")),
                StandardCommand.CANCEL.derive(Resources.getString(ApproveScaleDialog.class, "cancel")));
        return dlg;
    }

}
