package org.bidib.wizard.mvc.loco.view.speedo;

import java.awt.Frame;
import java.awt.Window;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.function.Function;

import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.TaskDialog.Command;
import org.oxbow.swingbits.dialog.task.TaskDialog.StandardCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;

public class ApproveSpeedRangeDialog {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApproveSpeedRangeDialog.class);

    private final SpeedScaleBeanModel speedScaleBeanModel;

    private int result = JOptionPane.CANCEL_OPTION;

    private final Integer scale;

    public ApproveSpeedRangeDialog(Frame frame, final SpeedScaleBeanModel speedScaleBeanModel) {

        this.scale = speedScaleBeanModel.getCv37Scale();

        this.speedScaleBeanModel = speedScaleBeanModel;

        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            formBuilder =
                FormBuilder
                    .create().columns("pref, 3dlu, pref, 2dlu, pref:grow").rows("pref, 3dlu, pref")
                    .panel(new FormDebugPanel());
        }
        else {
            formBuilder = FormBuilder.create().columns("pref, 3dlu, 30dlu, 2dlu, pref:grow").rows("pref, 3dlu, pref");
        }

        ValueModel vTargetMinValueModel =
            new PropertyAdapter<SpeedScaleBeanModel>(this.speedScaleBeanModel,
                SpeedScaleBeanModel.PROPERTYNAME_TARGET_MIN_SPEED, true);

        final ValueModel vTargetMinConverterModel =
            new ConverterValueModel(vTargetMinValueModel, new StringConverter(new DecimalFormat("#")));

        JTextField vTargetMin = WizardComponentFactory.createTextField(vTargetMinConverterModel, false);
        vTargetMin.setHorizontalAlignment(SwingConstants.RIGHT);
        // vMin.setEditable(false);

        formBuilder.add(Resources.getString(getClass(), "vMin")).xy(1, 1);
        formBuilder.add(vTargetMin).xy(3, 1);
        formBuilder.add(Resources.getString(getClass(), "kmh")).xy(5, 1);

        // target max speed
        ValueModel vTargetMaxValueModel =
            new PropertyAdapter<SpeedScaleBeanModel>(this.speedScaleBeanModel,
                SpeedScaleBeanModel.PROPERTYNAME_TARGET_MAX_SPEED, true);

        final ValueModel vTargetMaxConverterModel =
            new ConverterValueModel(vTargetMaxValueModel, new StringConverter(new DecimalFormat("#")));

        JTextField vTargetMax = WizardComponentFactory.createTextField(vTargetMaxConverterModel, false);
        vTargetMax.setHorizontalAlignment(SwingConstants.RIGHT);
        // vMin.setEditable(false);

        formBuilder.add(Resources.getString(getClass(), "vTargetMax")).xy(1, 3);
        formBuilder.add(vTargetMax).xy(3, 3);
        formBuilder.add(Resources.getString(getClass(), "kmh")).xy(5, 3);

        final Function<Integer, Integer> speedConverterToKmH = (val) -> {

            int speedVal = 0;
            if (ApproveSpeedRangeDialog.this.scale != null && scale > 1) {
                // val is the speed in mm/s --> convert to km/h with the scale factor
                speedVal = (int) (((double) val * scale) / 277.778);

                LOGGER.info("Converted speed: {} to speedVal: {}, scale: {}", val, speedVal, scale);
            }
            else {
                speedVal = val;
            }

            return speedVal;
        };
        Integer vMin = Optional.of(speedScaleBeanModel.getMeasuredMinSpeed()).map(speedConverterToKmH).orElse(0);
        Integer vMax = Optional.of(speedScaleBeanModel.getMeasuredMaxSpeed()).map(speedConverterToKmH).orElse(0);

        // prepare the dialog
        TaskDialog dlg =
            questionDialog(frame, Resources.getString(getClass(), "title"), TaskDialog.StandardIcon.QUESTION,
                Resources.getString(getClass(), "instruction", vMin, vMax), Resources.getString(getClass(), "message"));

        dlg.setFixedComponent(formBuilder.build());

        // if the model is valid, the write button is enabled.
        // Command okCommand = dlg.getCommands().toArray(new Command[0])[0];

        Command result = dlg.show();
        LOGGER.info("Result of validate scale dialog: {}", result.equals(StandardCommand.OK));

        if (result.equals(StandardCommand.OK)) {
            fireContinue();
        }
        else {
            fireCancel();
        }
    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");

        result = JOptionPane.YES_OPTION;
    }

    private void fireCancel() {

    }

    public int getResult() {
        return result;
    }

    public SpeedScaleBeanModel getSpeedScaleBeanModel() {
        return speedScaleBeanModel;
    }

    private static TaskDialog questionDialog(Window parent, String title, Icon icon, String instruction, String text) {

        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(instruction);
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg
            .setCommands(StandardCommand.OK.derive(Resources.getString(ApproveSpeedRangeDialog.class, "update")),
                StandardCommand.CANCEL.derive(Resources.getString(ApproveSpeedRangeDialog.class, "cancel")));
        return dlg;
    }
}
