package org.bidib.wizard.mvc.loco.view.speedo;

import java.awt.Frame;
import java.awt.Window;
import java.text.DecimalFormat;

import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.TaskDialog.Command;
import org.oxbow.swingbits.dialog.task.TaskDialog.StandardCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;

public class FinishOrRestoreDialog {

    private static final Logger LOGGER = LoggerFactory.getLogger(FinishOrRestoreDialog.class);

    private int result = JOptionPane.CANCEL_OPTION;

    public FinishOrRestoreDialog(Frame frame, final SpeedometerProgBeanModel speedometerProgBeanModel,
        final SpeedometerProgBeanModel backupSpeedometerProgBeanModel) {

        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            formBuilder =
                FormBuilder
                    .create().columns("pref, 3dlu, pref, 2dlu, pref:grow")
                    .rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref").panel(new FormDebugPanel());
        }
        else {
            formBuilder =
                FormBuilder
                    .create().columns("pref, 3dlu, 30dlu, 2dlu, pref:grow")
                    .rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        }

        formBuilder.addSeparator(Resources.getString(getClass(), "adjusted-values")).xyw(1, 1, 5);

        final ValueModel cv2ValueModel =
            new PropertyAdapter<SpeedometerProgBeanModel>(speedometerProgBeanModel,
                SpeedometerProgBeanModel.PROPERTYNAME_CV2_VMIN, false);
        JTextField cv2 =
            WizardComponentFactory
                .createTextField(new ConverterValueModel(cv2ValueModel, new StringConverter(new DecimalFormat("#"))),
                    false);
        cv2.setEnabled(false);
        formBuilder.add("CV2").xy(1, 3);
        formBuilder.add(cv2).xy(3, 3);
        // formBuilder.nextLine();

        final ValueModel cv5ValueModel =
            new PropertyAdapter<SpeedometerProgBeanModel>(speedometerProgBeanModel,
                SpeedometerProgBeanModel.PROPERTYNAME_CV5_VMAX, false);
        JTextField cv5 =
            WizardComponentFactory
                .createTextField(new ConverterValueModel(cv5ValueModel, new StringConverter(new DecimalFormat("#"))),
                    false);
        cv5.setEnabled(false);
        formBuilder.add("CV5").xy(1, 5);
        formBuilder.add(cv5).xy(3, 5);
        // formBuilder.nextLine();

        final ValueModel cv35ValueModel =
            new PropertyAdapter<SpeedometerProgBeanModel>(speedometerProgBeanModel,
                SpeedometerProgBeanModel.PROPERTYNAME_CV35, false);
        JTextField cv35 =
            WizardComponentFactory
                .createTextField(new ConverterValueModel(cv35ValueModel, new StringConverter(new DecimalFormat("#"))),
                    false);
        cv35.setEnabled(false);
        formBuilder.add("CV35").xy(1, 7);
        formBuilder.add(cv35).xy(3, 7);
        // formBuilder.nextLine();

        final ValueModel cv36ValueModel =
            new PropertyAdapter<SpeedometerProgBeanModel>(speedometerProgBeanModel,
                SpeedometerProgBeanModel.PROPERTYNAME_CV36, false);
        JTextField cv36 =
            WizardComponentFactory
                .createTextField(new ConverterValueModel(cv36ValueModel, new StringConverter(new DecimalFormat("#"))),
                    false);
        cv36.setEnabled(false);
        formBuilder.add("CV36").xy(1, 9);
        formBuilder.add(cv36).xy(3, 9);
        // formBuilder.nextLine();

        // prepare the dialog
        TaskDialog dlg =
            questionDialog(frame, Resources.getString(getClass(), "title"), TaskDialog.StandardIcon.QUESTION,
                Resources.getString(getClass(), "instruction"), Resources.getString(getClass(), "message"));

        dlg.setFixedComponent(formBuilder.build());

        Command result = dlg.show();
        LOGGER.info("Result of validate scale dialog: {}", result.equals(StandardCommand.OK));

        if (result.equals(StandardCommand.OK)) {
            fireContinue();
        }
        else {
            fireCancel();
        }

    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");

        result = JOptionPane.YES_OPTION;
    }

    private void fireCancel() {

    }

    public int getResult() {
        return result;
    }

    private static TaskDialog questionDialog(Window parent, String title, Icon icon, String instruction, String text) {

        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(instruction);
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg
            .setCommands(StandardCommand.OK.derive(Resources.getString(FinishOrRestoreDialog.class, "update")),
                StandardCommand.CANCEL.derive(Resources.getString(FinishOrRestoreDialog.class, "cancel")));
        return dlg;
    }

}
