package org.bidib.wizard.mvc.locolist.model;

import java.util.ArrayList;
import java.util.List;

import org.bidib.wizard.model.locolist.LocoListModel;

import com.jgoodies.binding.beans.Model;

public class LocoLibraryModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_LOCO_LIST = "locoList";

    public static final String PROPERTY_PUSH_TO_MOUSE = "pushToMouse";

    public static final String PROPERTY_EXECUTION_STATUS = "executionStatus";

    public static final String PROPERTY_EXECUTION_RESULT = "executionResult";

    private List<LocoListModel> locoList = new ArrayList<>();

    private boolean pushToMouse;

    private String executionStatus;

    public enum ExecutionResult {
        PENDING, RUNNING, PASSED, FAILED;
    }

    private ExecutionResult executionResult = ExecutionResult.PENDING;

    /**
     * @return the locoList
     */
    public List<LocoListModel> getLocoList() {
        return locoList;
    }

    /**
     * @param locoList
     *            the locoList to set
     */
    public void setLocoList(List<LocoListModel> locoList) {
        List<LocoListModel> oldValue = new ArrayList<>();
        oldValue.addAll(this.locoList);

        this.locoList.clear();
        if (locoList != null) {
            this.locoList.addAll(locoList);
        }

        firePropertyChange(PROPERTY_LOCO_LIST, oldValue, locoList);
    }

    /**
     * @return the pushToMouse
     */
    public boolean isPushToMouse() {
        return pushToMouse;
    }

    /**
     * @param pushToMouse
     *            the pushToMouse to set
     */
    public void setPushToMouse(boolean pushToMouse) {
        boolean oldValue = this.pushToMouse;

        this.pushToMouse = pushToMouse;

        firePropertyChange(PROPERTY_PUSH_TO_MOUSE, oldValue, pushToMouse);
    }

    /**
     * @return the executionStatus
     */
    public String getExecutionStatus() {
        return executionStatus;
    }

    /**
     * @param executionStatus
     *            the executionStatus to set
     */
    public void setExecutionStatus(String executionStatus) {
        String oldValue = this.executionStatus;
        this.executionStatus = executionStatus;

        firePropertyChange(PROPERTY_EXECUTION_STATUS, oldValue, executionStatus);
    }

    /**
     * @return the executionResult
     */
    public ExecutionResult getExecutionResult() {
        return executionResult;
    }

    /**
     * @param executionResult
     *            the executionResult to set
     */
    public void setExecutionResult(ExecutionResult executionResult) {
        ExecutionResult oldValue = this.executionResult;

        this.executionResult = executionResult;

        firePropertyChange(PROPERTY_EXECUTION_RESULT, oldValue, executionResult);
    }

}
