package org.bidib.wizard.mvc.locolist.view.wizard;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.PageList;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;

public class PushToMouseWizard {

    private static final Logger LOGGER = LoggerFactory.getLogger(PushToMouseWizard.class);

    public void showWizard(final LocoTableControllerListener locoTableController, final LocoTableModel locoTableModel) {
        LOGGER.info("Show the PushToMouseWizard.");

        int style = WizardStyle.WIZARD97_STYLE;
        WizardStyle.setStyle(style);

        Frame frame = null;

        final WizardDialog wizard = new WizardDialog(frame, Resources.getString(PushToMouseWizard.class, "title")) {
            private static final long serialVersionUID = 1L;

            @Override
            public ButtonPanel createButtonPanel() {

                ButtonPanel bp = super.createButtonPanel();
                ((JButton) bp.getButtonByName(NEXT)).setText(Resources.getString(PushToMouseWizard.class, "next"));
                ((JButton) bp.getButtonByName(BACK)).setText(Resources.getString(PushToMouseWizard.class, "back"));
                return bp;
            }
        };
        wizard.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        wizard
            .setDefaultGraphic(
                ImageUtils.createImageIcon(PushToMouseWizard.class, "/icons/wizard/pushToMouseWizard.png").getImage());

        wizard.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                wizard.dispose();
            }
        });

        // set new size
        wizard.setPreferredSize(new Dimension(600, 500));

        final LocoLibraryModel locoLibrary = new LocoLibraryModel();

        locoTableController.setLocoLibraryModel(locoLibrary);

        PageList model = new PageList();
        AbstractWizardPage page1 = new WelcomePage();
        AbstractWizardPage page2 = new SelectLocoPage(locoTableModel, locoLibrary);
        AbstractWizardPage page3 = new CompletionPage(locoLibrary);
        model.append(page1);
        model.append(page2);
        model.append(page3);

        wizard.setPageList(model);
        wizard.setStepsPaneNavigable(true);

        // the code below is to show you how to customize the finish and cancel action. You don't have to call these two
        // methods.
        wizard.setFinishAction(new AbstractAction(Resources.getString(PushToMouseWizard.class, "finish")) {
            public void actionPerformed(ActionEvent e) {
                if (wizard.closeCurrentPage(wizard.getButtonPanel().getButtonByName(ButtonNames.FINISH))) {
                    wizard.dispose();
                }
            }
        });
        wizard.setCancelAction(new AbstractAction(Resources.getString(PushToMouseWizard.class, "cancel")) {
            public void actionPerformed(ActionEvent e) {
                if (wizard.closeCurrentPage(wizard.getButtonPanel().getButtonByName(ButtonNames.CANCEL))) {
                    wizard.dispose();
                }
            }
        });

        wizard.pack();
        wizard.setResizable(false); // for wizard, it's better to make it not resizable.
        JideSwingUtilities.globalCenterWindow(wizard);
        wizard.setVisible(true);
    }
}
