package org.bidib.wizard.mvc.main.controller.wrapper;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.model.ports.Port;

public class NodePortWrapper {

    private final Map<Port<?>, ScriptEngine<PortScripting>> portRegistry = new LinkedHashMap<>();

    private final NodeInterface node;

    public NodePortWrapper(final NodeInterface node) {
        this.node = node;
    }

    public NodeInterface getNode() {
        return node;
    }

    public void addPort(Port<?> port, ScriptEngine<PortScripting> scriptEngine) {

        portRegistry.put(port, scriptEngine);
    }

    public ScriptEngine<PortScripting> removePort(Port<?> port) {

        ScriptEngine<PortScripting> scriptEngine = portRegistry.remove(port);
        return scriptEngine;
    }

    public boolean isEmpty() {
        return portRegistry.isEmpty();
    }

    public Set<Port<?>> getKeySet() {
        return portRegistry.keySet();
    }
}
