package org.bidib.wizard.mvc.main.model;

import javax.swing.SwingUtilities;

import org.bidib.jbidibc.core.node.listener.TransferListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransferListener implements TransferListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransferListener.class);

    private MainModel model;

    private final ConsoleService consoleService;

    public DefaultTransferListener(MainModel model, final ConsoleService consoleService) {
        this.model = model;
        this.consoleService = consoleService;
    }

    @Override
    public void receiveStarted() {
        model.getStatusModel().setRx(true);
    }

    @Override
    public void receiveStopped() {
        model.getStatusModel().setRx(false);
    }

    @Override
    public void sendStarted() {
        model.getStatusModel().setTx(true);
    }

    @Override
    public void sendStopped() {
        model.getStatusModel().setTx(false);
    }

    @Override
    public void ctsChanged(boolean cts, boolean manualEvent) {

        try {
            model.getStatusModel().setCts(cts);

            if (!manualEvent) {
                SwingUtilities.invokeLater(() -> {
                    ConsoleController.ensureConsoleVisible();
                    consoleService.addConsoleLine(ConsoleColor.blue, "CTS has changed: " + cts);
                });
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Signal CTS changed failed.", ex);
        }
    }
}
