package org.bidib.wizard.mvc.main.model;

import org.bidib.wizard.api.model.Accessory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;

public class SelectedAccessoryModel extends Model {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(SelectedAccessoryModel.class);

    public static final String PROPERTY_SELECTED_ACCESSORY = "selectedAccessory";

    private Accessory selectedAccessory;

    public void setSelectedAccessory(Accessory selectedAccessory) {
        Accessory oldValue = this.selectedAccessory;

        this.selectedAccessory = selectedAccessory;

        LOGGER.debug("Set the new selected accessory: {}, oldValue: {}", selectedAccessory, oldValue);

        firePropertyChange(PROPERTY_SELECTED_ACCESSORY, oldValue, selectedAccessory);
    }

    public Accessory getSelectedAccessory() {
        return selectedAccessory;
    }

    public void triggerLabelChanged() {
        firePropertyChange(PROPERTY_SELECTED_ACCESSORY, null, selectedAccessory);
    }

}
