package org.bidib.wizard.mvc.main.view.panel;

import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;

import javax.swing.JPanel;
import javax.swing.table.TableColumn;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.OutputStatusListener;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.status.AnalogPortStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonRenderer;

public class AnalogPortListPanel
    extends
    SimplePortListPanel<AnalogPortStatus, AnalogPort, OutputStatusListener<AnalogPortStatus, AnalogPort>, PortModelListener<AnalogPort>>
    implements TabVisibilityProvider, TabPanelProvider, TabComponentCreator {
    private static final long serialVersionUID = 1L;

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    public AnalogPortListPanel(MainModel model, final TabVisibilityListener tabVisibilityListener) {
        super(new SimplePortTableModel<AnalogPortStatus, AnalogPort, PortModelListener<AnalogPort>>() {
            private static final long serialVersionUID = 1L;

            @Override
            public int getColumnPortInstance() {
                return SimplePortTableModel.COLUMN_PORT_INSTANCE;
            }

            @Override
            public void notifyPortStatusChanged(final AnalogPort port) {
                // TODO Auto-generated method stub

            }

            @Override
            public void notifyPortConfigChanged(AnalogPort port) {
                // TODO Auto-generated method stub

            }

            @Override
            public void notifyPortLabelChanged(AnalogPort port) {
                // TODO Auto-generated method stub

            }

            @Override
            public void refreshRow(AnalogPort port, final IntConsumer rowConsumer) {

            }
        }, Resources.getString(AnalogPortListPanel.class, "emptyTable"));

        this.mainModel = model;
        this.tabVisibilityListener = tabVisibilityListener;

        // mainModel.addAnalogPortListListener(this);

        TableColumn buttonColumn = table.getColumnModel().getColumn(table.getColumnCount() - 1);

        buttonColumn.setCellRenderer(new ComboBoxWithButtonRenderer<>(table.getActions(AnalogPortStatus.START), ">"));
        buttonColumn.setCellEditor(new ComboBoxWithButtonEditor(table.getActions(AnalogPortStatus.START), ">"));
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof AnalogPortListPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void listChanged() {

        super.listChanged();

        tabVisibilityListener.setTabVisible(this, isTabVisible());
    }

    @Override
    public Class<?> getPortClass() {
        return AnalogPort.class;
    }

    @Override
    public boolean isTabVisible() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasAnalogPorts();
            LOGGER.debug("Check if tab is visible: {}", isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<AnalogPort> getPorts() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            return node.getAnalogPorts();
        }
        return Collections.emptyList();
    }
}
