package org.bidib.wizard.mvc.main.view.panel;

import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.mvc.loco.model.SpeedometerModel;
import org.bidib.wizard.mvc.loco.view.PomProgrammerRequestListener;
import org.bidib.wizard.mvc.loco.view.speedo.SpeedometerPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.ShutdownListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;

public class LocoPanelView implements TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoPanelView.class);

    private final SpeedometerPanel<?> speedometerPanel;

    private final JScrollPane scrollPaneContent;

    private final JPanel contentPanel;

    private class ShutdownListenerPanel extends JPanel implements ShutdownListener {
        private static final long serialVersionUID = 1L;

        @Override
        public void performShutdown() {

            LOGGER.info("Shutdown is performed, cleanup the panel.");
            cleanup();
        }
    }

    private class ShutdownListenerDebugPanel extends FormDebugPanel implements ShutdownListener {
        private static final long serialVersionUID = 1L;

        @Override
        public void performShutdown() {

            LOGGER.info("Shutdown is performed, cleanup the panel.");
            cleanup();
        }
    }

    public LocoPanelView(final LocoModel locoModel, final SpeedometerModel speedometerModel,
        final PomProgrammerRequestListener pomProgrammerRequestListener, final SettingsService settingsService) {

        // create the speedometer panel
        speedometerPanel =
            new SpeedometerPanel<>(speedometerModel, locoModel, pomProgrammerRequestListener, settingsService);

        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            formBuilder =
                FormBuilder
                    .create().columns("pref:grow").rows("fill:200dlu:grow").panel(new ShutdownListenerDebugPanel() {
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String getName() {
                            return speedometerPanel.getComponent().getName();
                        }
                    });
        }
        else {
            formBuilder =
                FormBuilder.create().columns("pref:grow").rows("fill:200dlu:grow").panel(new ShutdownListenerPanel() {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String getName() {
                        return speedometerPanel.getComponent().getName();
                    }
                });
        }

        scrollPaneContent = new JScrollPane();
        scrollPaneContent.setViewportView(speedometerPanel.getComponent());
        scrollPaneContent.setOpaque(FormsSetup.getOpaqueDefault());
        scrollPaneContent.getViewport().setOpaque(FormsSetup.getOpaqueDefault());

        formBuilder.add(scrollPaneContent).xy(1, 1);

        contentPanel = formBuilder.build();
    }

    @Override
    public JPanel getComponent() {
        return contentPanel;
    }

    public void addLogMessage(String logMessage, Object... args) {
        if (speedometerPanel != null) {
            speedometerPanel.addLogText(logMessage, args);
        }
    }

    public void cleanup() {
        if (speedometerPanel != null) {
            speedometerPanel.clearModelValues();
        }
    }

    public void clearModelValues() {

        if (speedometerPanel != null) {
            speedometerPanel.clearModelValues();
        }

    }
}
