package org.bidib.wizard.mvc.main.view.panel;

import javax.swing.event.ListSelectionListener;

import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.worklist.controller.WorkListItemProvider;
import org.bidib.wizard.nodescript.script.node.NodeScriptingSupportProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;

/**
 * The {@code MainPanel} contains the node list and the tab panel with the node details.
 */
public class MainPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainPanel.class);

    private NodeListPanel nodeListPanel;

    private TabPanel tabPanel;

    private final MainModel mainModel;

    private final ConnectionPhaseModel connectionPhaseModel;

    private final SettingsService settingsService;

    private final WizardLabelWrapper wizardLabelWrapper;

    private final NodeScriptingSupportProvider nodeScriptingSupportProvider;

    private final LookupService lookupService;

    public MainPanel(final MainModel mainModel, final ConnectionPhaseModel connectionPhaseModel,
        final SettingsService settingsService, final WizardLabelWrapper wizardLabelWrapper,
        final NodeScriptingSupportProvider nodeScriptingSupportProvider, final LookupService lookupService) {
        this.mainModel = mainModel;
        this.connectionPhaseModel = connectionPhaseModel;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.nodeScriptingSupportProvider = nodeScriptingSupportProvider;
        this.lookupService = lookupService;
    }

    public void create(
        final DockingDesktop desktop, final MainMenuListener mainMenuListener,
        final ApplicationContext applicationContext, final WorkListItemProvider workListItemProvider) {

        LOGGER.info("Create the tabPanel and nodeListPanel.");

        nodeListPanel =
            new NodeListPanel(this.mainModel, this.settingsService, this.wizardLabelWrapper, applicationContext,
                workListItemProvider);
        tabPanel =
            new TabPanel(this.mainModel, this.connectionPhaseModel, this.settingsService,
                this.nodeScriptingSupportProvider, mainMenuListener, applicationContext, this.lookupService);

        LOGGER.info("Register tabPanel and nodeListPanel in applicationContext.");
        DefaultApplicationContext.getInstance().register("tabPanel", this.tabPanel);
        DefaultApplicationContext.getInstance().register("nodeListPanel", this.nodeListPanel);

        desktop.addDockable(this.nodeListPanel);
        desktop.split(this.nodeListPanel, this.tabPanel, DockingConstants.SPLIT_RIGHT);
        desktop.setDockableWidth(this.nodeListPanel, 0.2d);

        LOGGER.info("Added node list and tab panel to desktop.");
    }

    public void addNodeListListener(NodeListActionListener l) {
        nodeListPanel.addNodeListListener(l);
    }

    public void addNodeListSelectionListener(ListSelectionListener l) {
        nodeListPanel.addListSelectionListener(l);
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        tabPanel.addCvDefinitionRequestListener(l);
    }

    public void performShutdown() {
        if (nodeListPanel != null) {
            nodeListPanel.performShutdown();
        }
        if (tabPanel != null) {
            tabPanel.performShutdown();
        }
    }

    public void savePendingChanges() {
        if (tabPanel != null) {
            tabPanel.savePendingChanges();
        }
    }
}
