package org.bidib.wizard.mvc.main.view.panel.listener;

import org.bidib.wizard.api.model.Accessory;

public interface AccessoryActionListener extends LabelChangedListener<Accessory> {
    /**
     * Export the accessory.
     * 
     * @param accessory
     *            the accessory to export
     */
    void exportAccessory(Accessory accessory);

    /**
     * Import the accessory.
     * 
     * @param accessory
     *            the accessory to import
     */
    void importAccessory(Accessory accessory);

    /**
     * Reload the accessory.
     * 
     * @param accessory
     *            the accessory to reload
     */
    void reloadAccessory(Accessory accessory);

    /**
     * Save the accessory.
     * 
     * @param accessory
     *            the accessory to save
     */
    void saveAccessory(Accessory accessory);
}
