package org.bidib.wizard.mvc.main.view.panel.renderer;

import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.wizard.api.locale.Resources;

public enum SwitchPortStatusLabel {

    // @formatter:off
    ON(SwitchPortEnum.ON, "on"), OFF(SwitchPortEnum.OFF, "off"),TEST(SwitchPortEnum.TEST, "test");
    // @formatter:on

    private final SwitchPortEnum type;

    private final String key;

    private final String label;

    SwitchPortStatusLabel(SwitchPortEnum type, String key) {
        this.type = type;
        this.key = key;
        this.label = Resources.getString(SwitchPortStatusLabel.class, key);
    }

    public SwitchPortEnum getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String toString() {
        return label;
    }

    public static SwitchPortStatusLabel valueOf(SwitchPortEnum type) {
        SwitchPortStatusLabel result = null;

        for (SwitchPortStatusLabel e : values()) {
            if (e.type == type) {
                result = e;
                break;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a switch port status label");
        }
        return result;
    }
}
