package org.bidib.wizard.mvc.main.view.table.converter;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.model.status.BidibStatus;

import com.jgoodies.binding.value.BindingConverter;

public class PortStatusToStringConverter implements BindingConverter<BidibStatus, String> {
    private String resourceClazzName;

    private String resourcePrefix;

    public PortStatusToStringConverter(String resourceClazzName) {
        this.resourceClazzName = resourceClazzName;
    }

    public PortStatusToStringConverter(String resourceClazzName, String resourcePrefix) {
        this.resourceClazzName = resourceClazzName;
        this.resourcePrefix = resourcePrefix;
    }

    public PortStatusToStringConverter(Class<?> resourceClazz) {
        this.resourceClazzName = Resources.trimWizardPackage(resourceClazz.getName());
    }

    public PortStatusToStringConverter(Class<?> resourceClazz, String resourcePrefix) {
        this.resourceClazzName = Resources.trimWizardPackage(resourceClazz.getName());
        this.resourcePrefix = resourcePrefix;
    }

    @Override
    public String targetValue(BidibStatus sourceValue) {
        if (sourceValue != null) {
            String resourceKey = resourceClazzName;
            if (resourceClazzName == null) {
                resourceKey = Resources.trimWizardPackage(sourceValue.getClass().getName());
            }
            if (resourcePrefix != null) {
                return Resources.getString(resourceClazzName, resourcePrefix + sourceValue.getKey());
            }
            else {
                return Resources.getString(resourceKey, sourceValue.getKey());
            }
        }
        return null;
    }

    @Override
    public BidibStatus sourceValue(String targetValue) {
        // TODO Auto-generated method stub
        return null;
    }

}
