package org.bidib.wizard.mvc.preferences.model;

import java.util.LinkedList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;

public class PairingStoreModel extends Model {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PairingStoreModel.class);

    private final List<PairingStoreEntryModel> pairings = new LinkedList<>();

    public static final String PROPERTY_PAIRINGS = "pairings";

    public List<PairingStoreEntryModel> getPairings() {
        return new LinkedList<>(pairings);
    }

    public void setPairings(List<PairingStoreEntryModel> pairings) {
        LOGGER.info("Set the pairings: {}", pairings);

        List<PairingStoreEntryModel> oldValue = new LinkedList<>();
        oldValue.addAll(this.pairings);

        this.pairings.clear();

        if (pairings != null) {
            this.pairings.addAll(pairings);
        }

        firePropertyChange(PROPERTY_PAIRINGS, oldValue, this.pairings);
    }

    public void addPairing(PairingStoreEntryModel pairingStoreEntry) {
        List<PairingStoreEntryModel> oldValue = new LinkedList<>();
        oldValue.addAll(this.pairings);

        this.pairings.add(pairingStoreEntry);

        firePropertyChange(PROPERTY_PAIRINGS, oldValue, this.pairings);
    }

    public void removePairing(PairingStoreEntryModel pairingStoreEntry) {
        List<PairingStoreEntryModel> oldValue = new LinkedList<>();
        oldValue.addAll(this.pairings);

        this.pairings.remove(pairingStoreEntry);

        firePropertyChange(PROPERTY_PAIRINGS, oldValue, this.pairings);
    }

}
