package org.bidib.wizard.mvc.preferences.view.panel;

import java.awt.BorderLayout;
import java.util.List;
import java.util.function.Consumer;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.WizardBindings;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.common.view.converter.StringToLocalDateTimeConverter;
import org.bidib.wizard.mvc.common.view.converter.StringToProtocolVersionConverter;
import org.bidib.wizard.mvc.preferences.model.PairingStoreEntryModel;
import org.bidib.wizard.mvc.preferences.model.PairingStoreModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TablePopupMenuInstaller;

public class PairingStoreSettingsPanel extends AbstractSettingsPanel<PairingStoreModel> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PairingStoreSettingsPanel.class);

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";

    private static final String ENCODED_DIALOG_ROW_SPECS =
        "fill:100dlu:grow, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";

    private final PairingStoreModel pairingStoreModel;

    private JPanel contentPanel;

    private SelectionInList<PairingStoreEntryModel> pairingSelection;

    private PresentationModel<PairingStoreEntryModel> detailsModel;

    private BufferedValueModel bufferedPairingsModel;

    private SortableTable pairingStoreTable;

    public PairingStoreSettingsPanel(final PairingStoreModel pairingStoreModel,
        final Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);

        this.pairingStoreModel = pairingStoreModel;
    }

    public JPanel createPanel() {

        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            JPanel panel = new FormDebugPanel();
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        else {
            JPanel panel = new JPanel(new BorderLayout());
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        // TODO use value model here and only update settings on focus lost

        preparePresentationModel(this.pairingStoreModel);

        this.bufferedPairingsModel = this.presentationModel.getBufferedModel(PairingStoreModel.PROPERTY_PAIRINGS);

        pairingSelection =
            new SelectionInList<PairingStoreEntryModel>(
                this.bufferedPairingsModel /* this.pairingStoreModel.getPairings() */);

        pairingStoreTable =
            new SortableTable(new PairingStoreTableModel(pairingSelection, "UID", "Requestor", "ProductName",
                "UserName", "ProtocolVersion", "Paired", "Last seen"));

        detailsModel = new PresentationModel<PairingStoreEntryModel>(pairingSelection);

        WizardBindings.bind(pairingStoreTable, pairingSelection);

        dialogBuilder.add(new JScrollPane(pairingStoreTable)).xyw(1, 1, 5);

        // add popup menu for table
        final JPopupMenu pairingStoreTableMenu = new PairingStoreTableMenu(this);
        final TablePopupMenuInstaller installer = new TablePopupMenuInstaller(pairingStoreTable) {
            @Override
            protected JPopupMenu createPopupMenu() {
                return pairingStoreTableMenu;
            }

            @Override
            protected void customizeMenuItems(JTable table, JPopupMenu popup, int clickingRow, int clickingColumn) {

                super.customizeMenuItems(table, popup, clickingRow, clickingColumn);
            }
        };

        // UID
        final BufferedValueModel bufferedUidModel = detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_UID);

        dialogBuilder.add(Resources.getString(getClass(), "uid") + ":").xy(1, 3);
        final JTextField uid = WizardComponentFactory.createTextField(bufferedUidModel, false);
        uid.setEditable(false);
        dialogBuilder.add(uid).xyw(3, 3, 3);

        // Requestor name
        final BufferedValueModel bufferedRequestorNameModel =
            detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_REQUESTOR_NAME);

        dialogBuilder.add(Resources.getString(getClass(), "requestorName") + ":").xy(1, 5);
        final JTextField requestorName = WizardComponentFactory.createTextField(bufferedRequestorNameModel, false);
        requestorName.setEditable(false);
        dialogBuilder.add(requestorName).xyw(3, 5, 3);

        // Product name
        final BufferedValueModel bufferedProductNameModel =
            detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_PRODUCT_NAME);

        dialogBuilder.add(Resources.getString(getClass(), "productName") + ":").xy(1, 7);
        final JTextField productName = WizardComponentFactory.createTextField(bufferedProductNameModel, false);
        productName.setEditable(false);
        dialogBuilder.add(productName).xyw(3, 7, 3);

        // User name
        final BufferedValueModel bufferedUserNameModel =
            detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_USER_NAME);

        dialogBuilder.add(Resources.getString(getClass(), "userName") + ":").xy(1, 9);
        final JTextField userName = WizardComponentFactory.createTextField(bufferedUserNameModel, false);
        userName.setEditable(false);
        dialogBuilder.add(userName).xyw(3, 9, 3);

        // Protocol version
        final ValueModel protocolVersionModel =
            new ConverterValueModel(detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_PROTOCOL_VERSION),
                new StringToProtocolVersionConverter());

        dialogBuilder.add(Resources.getString(getClass(), "protocolVersion") + ":").xy(1, 11);
        final JTextField protocolVersion = WizardComponentFactory.createTextField(protocolVersionModel, false);
        protocolVersion.setEditable(false);
        dialogBuilder.add(protocolVersion).xyw(3, 11, 3);

        // Paired
        final BufferedValueModel bufferedPairedModel =
            detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_PAIRED);

        dialogBuilder.add(Resources.getString(getClass(), "paired") + ":").xy(1, 13);
        JCheckBox paired = WizardComponentFactory.createCheckBox(bufferedPairedModel, null);
        paired.setEnabled(false);
        dialogBuilder.add(paired).xyw(3, 13, 3);

        // Last seen
        final ValueModel lastSeenModel =
            new ConverterValueModel(detailsModel.getBufferedModel(PairingStoreEntryModel.PROPERTY_LAST_SEEN),
                new StringToLocalDateTimeConverter());

        dialogBuilder.add(Resources.getString(getClass(), "lastSeen") + ":").xy(1, 15);
        final JTextField lsatSeen = WizardComponentFactory.createTextField(lastSeenModel, false);
        lsatSeen.setEditable(false);
        dialogBuilder.add(lsatSeen).xyw(3, 15, 3);

        contentPanel = dialogBuilder.build();
        contentPanel.setOpaque(false);
        return contentPanel;
    }

    public void removeSelectedEntry() {

        PairingStoreEntryModel selected = this.pairingSelection.getSelection();
        if (selected != null) {
            LOGGER.info("Remove selected model from pairing store: {}", selected);

            List<PairingStoreEntryModel> pairingList =
                (List<PairingStoreEntryModel>) this.bufferedPairingsModel.getValue();
            LOGGER.info("Fetched buffered value: {}", pairingList);

            pairingList.remove(selected);
            this.bufferedPairingsModel.setValue(pairingList);

            this.pairingSelection.clearSelection();
            int size = this.pairingSelection.getSize();
            this.pairingSelection.fireContentsChanged(0, (size > 0) ? size - 1 : 0);
        }
    }

}
