package org.bidib.wizard.mvc.pt.view.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import org.apache.commons.lang3.BooleanUtils;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CvUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.view.command.PtOperationCommand;
import org.bidib.wizard.mvc.pt.view.command.PtRailcomConfigCommand;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;

public class RailcomPanel extends AbstractPtPanel<RailcomProgBeanModel> {

    private ValueModel channel1ValueModel;

    private ValueModel channel2ValueModel;

    private ValueModel channelUsageValueModel;

    private ValueModel railcomPlusValueModel;

    private RailcomProgBeanModel railcomProgBeanModel;

    private ValidationResultModel railcomValidationModel;

    private Icon infoIcon;

    private JComponent[] components;

    public RailcomPanel(PtProgrammerModel cvProgrammerModel) {
        super(cvProgrammerModel);

        infoIcon = ImageUtils.createImageIcon(RailcomPanel.class, "/icons/information.png");

        railcomProgBeanModel = new RailcomProgBeanModel();
        setProgCommandAwareBeanModel(railcomProgBeanModel);
    }

    @Override
    protected void createWorkerPanel(FormBuilder builder, final int[] rowHolder) {

        // goto next line
        int row = rowHolder[0];

        builder.add(new JLabel(Resources.getString(getClass(), "railcom-message"))).xyw(1, row, 7);

        row += 2;
        builder.appendRows("p, 3dlu");

        builder
            .add(new JLabel(Resources.getString(getClass(), "railcom-activate-info"), infoIcon, SwingConstants.LEADING))
            .xyw(1, row, 7);

        row += 2;
        builder.appendRows("p, 3dlu");

        channel1ValueModel =
            new PropertyAdapter<RailcomProgBeanModel>(railcomProgBeanModel, RailcomProgBeanModel.PROPERTYNAME_CHANNEL_1,
                true);

        JCheckBox checkChannel1 =
            WizardComponentFactory.createCheckBox(channel1ValueModel, Resources.getString(getClass(), "channel1"));
        builder.add(checkChannel1).xyw(1, row, 7);

        row += 2;
        builder.appendRows("p, 3dlu");
        // builder.nextLine();

        channel2ValueModel =
            new PropertyAdapter<RailcomProgBeanModel>(railcomProgBeanModel, RailcomProgBeanModel.PROPERTYNAME_CHANNEL_2,
                true);

        JCheckBox checkChannel2 =
            WizardComponentFactory.createCheckBox(channel2ValueModel, Resources.getString(getClass(), "channel2"));
        builder.add(checkChannel2).xyw(1, row, 7);

        row += 2;
        builder.appendRows("p, 3dlu");
        // builder.nextLine();

        channelUsageValueModel =
            new PropertyAdapter<RailcomProgBeanModel>(railcomProgBeanModel,
                RailcomProgBeanModel.PROPERTYNAME_CHANNEL_USAGE, true);

        JCheckBox checkChannelUsage =
            WizardComponentFactory
                .createCheckBox(channelUsageValueModel, Resources.getString(getClass(), "channelUsage"));
        checkChannelUsage.setToolTipText(Resources.getString(getClass(), "channelUsage.tooltip"));
        builder.add(checkChannelUsage).xyw(1, row, 7);

        row += 2;
        builder.appendRows("p, 3dlu");
        // builder.nextLine();

        railcomPlusValueModel =
            new PropertyAdapter<RailcomProgBeanModel>(railcomProgBeanModel,
                RailcomProgBeanModel.PROPERTYNAME_RAILCOM_PLUS, true);

        JCheckBox checkRailcomPlus =
            WizardComponentFactory
                .createCheckBox(railcomPlusValueModel, Resources.getString(getClass(), "railcomplus"));
        builder.add(checkRailcomPlus).xyw(1, row, 7);

        row += 2;
        builder.appendRows("p, 3dlu");
        // builder.nextLine();

        ValidationComponentUtils.setMessageKey(checkRailcomPlus, "validation.railcomplus_key");

        components = new JComponent[4];
        components[0] = checkChannel1;
        components[1] = checkChannel2;
        components[2] = checkChannelUsage;
        components[3] = checkRailcomPlus;

        // add a validation model that can trigger a button state with the validState property
        railcomValidationModel = new PtValidationResultModel();

        railcomProgBeanModel
            .addPropertyChangeListener(RailcomProgBeanModel.PROPERTYNAME_RAILCOM_PLUS, new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LOGGER.debug("RailCom+ has changed: {}", railcomProgBeanModel.isRailcomPlus());
                    triggerValidation();
                }
            });
        railcomProgBeanModel
            .addPropertyChangeListener(RailcomProgBeanModel.PROPERTYNAME_CHANNEL_2, new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LOGGER.debug("Channel2 has changed: {}", railcomProgBeanModel.isChannel2());
                    triggerValidation();
                }
            });

        readButtonEnabled = new ValueHolder(false);

        readButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                fireRead();
            }
        });

        writeButtonEnabled = new ValueHolder(true);
        // writeButton.setEnabled(false);
        writeButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                fireWrite();
            }
        });

        PropertyConnector
            .connect(railcomValidationModel, PtValidationResultModel.PROPERTY_VALID_STATE, writeButton, "enabled");

        // prepare the read and write buttons
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton(readButton, writeButton).build();
        builder.add(progActionButtons).xyw(1, row, 7);

        // update the row holder
        rowHolder[0] = row;
    }

    @Override
    protected Object getCurrentOperation() {
        return railcomProgBeanModel.getCurrentOperation();
    }

    @Override
    protected void doBindButtons() {
        // add bindings for enable/disable the write button
        PropertyConnector.connect(readButtonEnabled, "value", readButton, "enabled");
        PropertyConnector.connect(writeButtonEnabled, "value", writeButton, "enabled");
    }

    @Override
    protected ValidationResultModel getValidationResultModel() {
        return railcomValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationSupport support = new PropertyValidationI18NSupport(railcomValidationModel, "validation");

        // if the railcom plus is set we must set railcom on channel 2
        if (BooleanUtils.isTrue((Boolean) railcomPlusValueModel.getValue())
            && BooleanUtils.isFalse((Boolean) channel2ValueModel.getValue())) {
            support.addError("railcomplus_key", "channel2_required");
        }

        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", validationResult);
        return validationResult;
    }

    @Override
    protected void triggerValidation() {
        ValidationResult validationResult = validate();
        railcomValidationModel.setResult(validationResult);
    }

    @Override
    protected void disableInputElements() {

        for (JComponent comp : components) {
            comp.setEnabled(false);
        }

        super.disableInputElements();
    }

    @Override
    protected void enableInputElements() {

        for (JComponent comp : components) {
            comp.setEnabled(true);
        }

        readButtonEnabled.setValue(true);
        writeButtonEnabled.setValue(true);
    }

    private void fireWrite() {
        // disable the input elements
        disableInputElements();

        // clear the executed commands
        railcomProgBeanModel.getExecutedProgCommands().clear();

        List<PtOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands =
            railcomProgBeanModel.getProgCommands();
        progCommands.clear();

        // Set the bits in CV 28
        progCommands
            .add(new PtRailcomConfigCommand(PtOperation.WR_BIT, 28,
                CvUtils.preparePtBitCvValue(true, 0, Boolean.TRUE.equals(channel1ValueModel.getValue()) ? 1 : 0)));
        progCommands
            .add(new PtRailcomConfigCommand(PtOperation.WR_BIT, 28,
                CvUtils.preparePtBitCvValue(true, 1, Boolean.TRUE.equals(channel2ValueModel.getValue()) ? 1 : 0)));
        progCommands
            .add(new PtRailcomConfigCommand(PtOperation.WR_BIT, 28,
                CvUtils.preparePtBitCvValue(true, 2, Boolean.TRUE.equals(channelUsageValueModel.getValue()) ? 1 : 0)));
        progCommands
            .add(new PtRailcomConfigCommand(PtOperation.WR_BIT, 28,
                CvUtils.preparePtBitCvValue(true, 7, Boolean.TRUE.equals(railcomPlusValueModel.getValue()) ? 1 : 0)));

        ptResultProxyModel.setCommandStationProgState(null);

        fireNextCommand();
    }

    private void fireRead() {
        // disable the input elements
        disableInputElements();

        // clear the executed commands
        railcomProgBeanModel.getExecutedProgCommands().clear();

        List<PtOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands =
            railcomProgBeanModel.getProgCommands();
        progCommands.clear();

        // Read the CV 28
        progCommands.add(new PtRailcomConfigCommand(PtOperation.RD_BYTE, 28, ByteUtils.getLowByte(0)));

        ptResultProxyModel.setCommandStationProgState(null);

        fireNextCommand();
    }
}
