package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.model.TurnTableType;

public class StepControlAspectCellRenderer extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    private final ImageIcon okIcon;

    private final ImageIcon errorIcon;

    private final StepControlModel stepControlModel;

    public StepControlAspectCellRenderer(final StepControlModel stepControlModel, final ImageIcon okIcon,
        final ImageIcon errorIcon) {
        this.stepControlModel = stepControlModel;
        this.okIcon = okIcon;
        this.errorIcon = errorIcon;
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof StepControlAspect) {
            StepControlAspect stepControlAspect = (StepControlAspect) value;
            Long position =
                stepControlAspect.getPosition() != null ? (stepControlAspect.getPosition()) & 0xffffffffL : null;
            Long positionOpposite =
                stepControlAspect.getOppositePosition() != null
                    ? (stepControlAspect.getOppositePosition()) & 0xffffffffL : null;

            String text = null;
            boolean isValid = stepControlAspect.isValid();
            if (TurnTableType.round == stepControlModel.getTurnTableType()) {
                if (position != null && positionOpposite != null) {
                    text = String.format("%d - %d", position, positionOpposite);
                }
                else if (position != null) {
                    text = String.format("%d - ?", position);
                }
                else {
                    text = String.format("? - %d", positionOpposite);
                }

                isValid = stepControlAspect.isValid() && stepControlAspect.isOppositeValid();
            }
            else if (position != null) {
                text = String.format("%d", position);
            }

            JLabel label = (JLabel) super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            label.setIcon(isValid ? okIcon : errorIcon);
            return label;
        }
        else {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

}
