package org.bidib.wizard.mvc.stepcontrol.view.converter;

import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect.Polarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.value.BindingConverter;

public class BooleanToPolarityConverter implements BindingConverter<Polarity, Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BooleanToPolarityConverter.class);

    @Override
    public Boolean targetValue(Polarity sourceValue) {
        if (sourceValue != null) {

            return sourceValue == Polarity.inverted;
        }
        return null;
    }

    @Override
    public Polarity sourceValue(Boolean targetValue) {
        try {
            if (targetValue != null) {

                return targetValue.booleanValue() ? Polarity.inverted : Polarity.normal;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse the target value into valid Polarity: {}", targetValue);
        }
        return null;
    }

}
