package org.bidib.wizard.mvc.tips.view;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;

import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.tips.controller.TipOfDayClosedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.tipoftheday.TipOfTheDayDialog;
import com.jidesoft.tipoftheday.TipOfTheDaySource;

public class TipOfDayView {

    private static final Logger LOGGER = LoggerFactory.getLogger(TipOfDayView.class);

    public void showTipsOfTheDay(
        final DefaultBusyFrame frame, final TipOfDayClosedListener listener, final SettingsService settingsService,
        TipOfTheDaySource tipOfTheDaySource) {
        tipOfTheDaySource.setCurrentTipIndex(getLastTipOfDayIndex(settingsService.getWizardSettings()));
        URL styleSheet = TipOfTheDayDialog.class.getResource("/tips.css");
        TipOfTheDayDialog dialog =
            new TipOfTheDayDialog(frame, tipOfTheDaySource, new AbstractAction("Show Tips on startup") {
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof JCheckBox) {
                        JCheckBox checkBox = (JCheckBox) e.getSource();
                        setPrefBooleanValue(settingsService.getWizardSettings(), checkBox.isSelected());
                    }
                    // change your user preference
                }
            }, styleSheet);

        dialog.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosed(WindowEvent e) {
                LOGGER.info("Window was closed.");
                super.windowClosed(e);

                int currentTipIndex = tipOfTheDaySource.getCurrentTipIndex();
                if (currentTipIndex > -1) {
                    LOGGER.info("Save the currentTipIndex: {}", currentTipIndex);
                    setLastTipOfDayIndex(settingsService, currentTipIndex);
                }

                if (listener != null) {
                    listener.closed();
                }
            }
        });

        dialog.setShowTooltip(getPrefBooleanValue(settingsService.getWizardSettings()));
        dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        dialog.setResizable(false);
        dialog.pack();
        JideSwingUtilities.globalCenterWindow(dialog);
        dialog.setVisible(true);
    }

    private boolean getPrefBooleanValue(final WizardSettingsInterface wizardSettings) {
        return wizardSettings.isShowTipOfDay();
    }

    private void setPrefBooleanValue(final WizardSettingsInterface wizardSettings, boolean showTipOfDay) {
        wizardSettings.setShowTipOfDay(showTipOfDay);
    }

    private int getLastTipOfDayIndex(final WizardSettingsInterface wizardSettings) {
        return wizardSettings.getLastTipOfDayIndex();
    }

    private void setLastTipOfDayIndex(final SettingsService settingsService, int currentTipIndex) {
        WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        wizardSettings.setLastTipOfDayIndex(currentTipIndex);
        settingsService.storeSettings();
    }
}
