package org.bidib.wizard.mvc.worklist.controller.actions;

import javax.swing.JOptionPane;

import org.bidib.wizard.api.event.FirmwareUpdateWorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.firmwarerepo.core.NodeFirmwareRepoService;
import org.bidib.wizard.mvc.worklist.controller.ActionAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

import com.vlsolutions.swing.docking.DockingDesktop;

public class DownloadFirmwareAction implements WorkListAction<FirmwareUpdateWorkListItemEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadFirmwareAction.class);

    private final ApplicationContext applicationContext;

    public DownloadFirmwareAction(final ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void apply(DockingDesktop desktop, FirmwareUpdateWorkListItemEvent actionEvent)
        throws ActionAbortedException {

        LOGGER.info("Let the node firmware repo service download the new firmware.");

        int result =
            JOptionPane
                .showConfirmDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()),
                    Resources.getString(DownloadFirmwareAction.class, "download-new-firmware.text"),
                    Resources.getString(DownloadFirmwareAction.class, "download-new-firmware.title"),
                    JOptionPane.YES_OPTION | JOptionPane.CANCEL_OPTION);

        if (result == JOptionPane.YES_OPTION) {
            LOGGER.info("Download the new firmware to the local repo.");

            final NodeFirmwareRepoService nodeFirmwareRepoService =
                applicationContext.getBean(NodeFirmwareRepoService.class);
            nodeFirmwareRepoService.downloadNewRemoteFirmwareAvailable();
        }
        else {
            LOGGER.info("Download the new firmware to the local repo dialog was cancelled.");
            throw new ActionAbortedException("Download the new firmware to the local repo dialog was cancelled.");
        }
    }

}
