package org.bidib.wizard.utils;

import java.util.List;

import org.bidib.jbidibc.core.schema.bidib2.DirectionType;
import org.bidib.jbidibc.core.schema.bidib2.FunctionAccessoryNotification;
import org.bidib.jbidibc.core.schema.bidib2.FunctionCriticalSection;
import org.bidib.jbidibc.core.schema.bidib2.FunctionDelay;
import org.bidib.jbidibc.core.schema.bidib2.FunctionFlag;
import org.bidib.jbidibc.core.schema.bidib2.FunctionInput;
import org.bidib.jbidibc.core.schema.bidib2.FunctionMacro;
import org.bidib.jbidibc.core.schema.bidib2.FunctionOutputLight;
import org.bidib.jbidibc.core.schema.bidib2.FunctionOutputSwitch;
import org.bidib.jbidibc.core.schema.bidib2.MacroPoint;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointAccessoryNotification;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointCriticalSection;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointDelay;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointFlag;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointInput;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointMacro;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputAnalog;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputBacklight;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputLight;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputMotor;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputServo;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSound;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSwitch;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointOutputSwitchPair;
import org.bidib.jbidibc.core.schema.bidib2.MacroPointServoMoveQuery;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.CriticalFunction;
import org.bidib.wizard.api.model.function.DelayFunction;
import org.bidib.wizard.api.model.function.DelayFunction.DelayFunctionBuilder;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.RandomDelayFunction.RandomDelayFunctionBuilder;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.utils.FlagListUtils;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.CriticalFunctionStatus;
import org.bidib.wizard.model.status.FlagStatus;
import org.bidib.wizard.model.status.InputStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionConversionFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionConversionFactory.class);

    public MacroPoint convert(Function<? extends BidibStatus> function) {
        MacroPoint macroPoint = null;

        LOGGER.info("Current key: {}", function.getKey());
        switch (function.getKey()) {
            case Function.KEY_ACCESSORY_OKAY:
                macroPoint = convertAccessoryAction((AccessoryOkayFunction) function);
                break;
            case Function.KEY_ANALOG:
                macroPoint = convertAnalogPortAction((AnalogPortAction) function);
                break;
            case Function.KEY_BACKLIGHT:
                macroPoint = convertBacklightPortAction((BacklightPortAction) function);
                break;
            case Function.KEY_CRITICAL:
                macroPoint = convertCriticalAction((CriticalFunction) function);
                break;
            case Function.KEY_DELAY:
                macroPoint = convertDelayAction((DelayFunction) function);
                break;
            case Function.KEY_FLAG:
                macroPoint = convertFlagAction((FlagFunction) function);
                break;
            case Function.KEY_INPUT:
                macroPoint = convertInputAction((InputFunction) function);
                break;
            case Function.KEY_LIGHT:
                macroPoint = convertLightPortAction((LightPortAction) function);
                break;
            case Function.KEY_MACRO:
                macroPoint = convertMacroAction((MacroFunction) function);
                break;
            case Function.KEY_MOTOR:
                macroPoint = convertMotorPortAction((MotorPortAction) function);
                break;
            case Function.KEY_RANDOM_DELAY:
                macroPoint = convertRandomDelayAction((RandomDelayFunction) function);
                break;
            case Function.KEY_SERVO:
                macroPoint = convertServoPortAction((ServoPortAction) function);
                break;
            case Function.KEY_SERVO_MOVE_QUERY:
                macroPoint = convertServoMoveQueryAction((ServoMoveQueryFunction) function);
                break;
            case Function.KEY_SOUND:
                macroPoint = convertSoundPortAction((SoundPortAction) function);
                break;
            case Function.KEY_SWITCH:
                macroPoint = convertSwitchPortAction((SwitchPortAction) function);
                break;
            case Function.KEY_SWITCHPAIR:
                macroPoint = convertSwitchPairPortAction((SwitchPairPortAction) function);
                break;
            default:
                LOGGER.warn("Unknown function detected: {}", function);
                break;
        }

        return macroPoint;
    }

    public Function<? extends BidibStatus> convert(MacroPoint macroPoint, final NodeInterface node) {
        Function<? extends BidibStatus> function = null;

        LOGGER.info("Current macroPoint: {}", macroPoint);

        if (macroPoint instanceof MacroPointInput) {
            function = convertInputPoint((MacroPointInput) macroPoint, node.getInputPorts());
        }
        else if (macroPoint instanceof MacroPointMacro) {
            function = convertMacroPointMacro((MacroPointMacro) macroPoint);
        }
        else if (macroPoint instanceof MacroPointFlag) {
            function = convertMacroPointFlag((MacroPointFlag) macroPoint, node.getFlags());
        }
        else if (macroPoint instanceof MacroPointDelay) {
            function = convertMacroPointDelay((MacroPointDelay) macroPoint);
        }
        else if (macroPoint instanceof MacroPointCriticalSection) {
            function = convertMacroPointCriticalSection((MacroPointCriticalSection) macroPoint);
        }
        else if (macroPoint instanceof MacroPointAccessoryNotification) {
            function =
                convertMacroPointAccessoryNotification((MacroPointAccessoryNotification) macroPoint,
                    node.getInputPorts());
        }
        else if (macroPoint instanceof MacroPointServoMoveQuery) {
            function = convertMacroPointServoMoveQuery((MacroPointServoMoveQuery) macroPoint, node.getServoPorts());
        }
        else if (macroPoint instanceof MacroPointOutputServo) {
            function = convertMacroPointOutputServo((MacroPointOutputServo) macroPoint, node.getServoPorts());
        }
        else if (macroPoint instanceof MacroPointOutputSwitch) {
            function = convertMacroPointOutputSwitch((MacroPointOutputSwitch) macroPoint, node.getSwitchPorts());
        }
        else if (macroPoint instanceof MacroPointOutputSwitchPair) {
            function =
                convertMacroPointOutputSwitchPair((MacroPointOutputSwitchPair) macroPoint, node.getSwitchPairPorts());
        }
        else if (macroPoint instanceof MacroPointOutputSound) {
            function = convertMacroPointOutputSound((MacroPointOutputSound) macroPoint, node.getSoundPorts());
        }
        else if (macroPoint instanceof MacroPointOutputMotor) {
            function = convertMacroPointOutputMotor((MacroPointOutputMotor) macroPoint, node.getMotorPorts());
        }
        else if (macroPoint instanceof MacroPointOutputAnalog) {
            function = convertMacroPointOutputAnalog((MacroPointOutputAnalog) macroPoint, node.getAnalogPorts());
        }
        else if (macroPoint instanceof MacroPointOutputLight) {
            function = convertMacroPointOutputLight((MacroPointOutputLight) macroPoint, node.getLightPorts());
        }
        else if (macroPoint instanceof MacroPointOutputBacklight) {
            function =
                convertMacroPointOutputBacklight((MacroPointOutputBacklight) macroPoint, node.getBacklightPorts());
        }
        else {
            LOGGER.warn("Unhandled macroPoint detected: {}", macroPoint);
        }

        return function;
    }

    protected MacroPoint convertInputAction(InputFunction function) {
        MacroPointInput macroPoint = new MacroPointInput();

        switch (function.getAction()) {
            case QUERY0:
                macroPoint.setFunction(FunctionInput.WAIT_FOR_0);
                break;
            case QUERY1:
                macroPoint.setFunction(FunctionInput.WAIT_FOR_1);
                break;
            default:
                LOGGER.warn("Unknown input action detected: {}", function);
                break;
        }

        macroPoint.setInputNumber(function.getInput().getId());

        return macroPoint;
    }

    protected InputFunction convertInputPoint(MacroPointInput macroPoint, List<InputPort> inputPorts) {
        final InputFunction function = new InputFunction();

        switch (macroPoint.getFunction()) {
            case WAIT_FOR_0:
                function.setAction(InputStatus.QUERY0);
                break;
            case WAIT_FOR_1:
                function.setAction(InputStatus.QUERY1);
                break;
            default:
                LOGGER.warn("Unknown input action detected: {}", macroPoint);
                break;
        }

        InputPort inputPort = PortListUtils.findPortByPortNumber(inputPorts, macroPoint.getInputNumber());
        function.setInput(inputPort);

        return function;
    }

    protected MacroPoint convertMacroAction(MacroFunction function) {
        MacroPointMacro macroPoint = new MacroPointMacro();

        switch (function.getAction()) {
            case START:
                macroPoint.setFunction(FunctionMacro.START);
                break;
            case STOP:
                macroPoint.setFunction(FunctionMacro.STOP);
                break;
            default:
                LOGGER.warn("Unknown macro action detected: {}", function);
                break;
        }
        macroPoint.setMacroNumber(function.getMacroId());

        return macroPoint;
    }

    protected MacroFunction convertMacroPointMacro(final MacroPointMacro macroPoint) {
        MacroFunction function = new MacroFunction();
        switch (macroPoint.getFunction()) {
            case START:
                function.setAction(MacroStatus.START);
                break;
            case STOP:
                function.setAction(MacroStatus.STOP);
                break;
            default:
                LOGGER.warn("Unknown macro action detected: {}", macroPoint);
                break;
        }
        function.setMacroId(macroPoint.getMacroNumber());
        return function;
    }

    protected MacroPoint convertFlagAction(FlagFunction function) {
        MacroPointFlag macroPoint = new MacroPointFlag();

        switch (function.getAction()) {
            case CLEAR:
                macroPoint.setFunction(FunctionFlag.RESET);
                break;
            case QUERY_0:
                macroPoint.setFunction(FunctionFlag.QUERY_0);
                break;
            case QUERY_1:
                macroPoint.setFunction(FunctionFlag.QUERY_1);
                break;
            case SET:
                macroPoint.setFunction(FunctionFlag.SET);
                break;
            default:
                LOGGER.warn("Unknown flag action detected: {}", function);
                break;
        }

        macroPoint.setFlagNumber(function.getFlag().getId());

        return macroPoint;
    }

    protected FlagFunction convertMacroPointFlag(MacroPointFlag macroPoint, final List<Flag> flags) {
        FlagFunction function = new FlagFunction();

        switch (macroPoint.getFunction()) {
            case RESET:
                function.setAction(FlagStatus.CLEAR);
                break;
            case QUERY_0:
                function.setAction(FlagStatus.QUERY_0);
                break;
            case QUERY_1:
                function.setAction(FlagStatus.QUERY_1);
                break;
            case SET:
                function.setAction(FlagStatus.SET);
                break;
            default:
                LOGGER.warn("Unknown flag action detected: {}", macroPoint);
                break;
        }

        Flag flag = FlagListUtils.findFlagByNumber(flags, macroPoint.getFlagNumber());
        function.setFlag(flag);

        return function;
    }

    protected MacroPoint convertDelayAction(DelayFunction function) {
        MacroPointDelay macroPoint = new MacroPointDelay();

        macroPoint.setFunction(FunctionDelay.FIXED);
        macroPoint.setDelay(function.getDelay());

        return macroPoint;
    }

    protected MacroPoint convertRandomDelayAction(RandomDelayFunction function) {
        MacroPointDelay macroPoint = new MacroPointDelay();

        macroPoint.setFunction(FunctionDelay.RANDOM);
        macroPoint.setDelay(function.getMaximumValue());

        return macroPoint;
    }

    protected Function<? extends BidibStatus> convertMacroPointDelay(MacroPointDelay macroPoint) {
        if (FunctionDelay.FIXED.equals(macroPoint.getFunction())) {
            return DelayFunctionBuilder.delayFunction().withDelay(macroPoint.getDelay()).build();
        }

        return RandomDelayFunctionBuilder.randomDelayFunction().withDelay(macroPoint.getDelay()).build();
    }

    protected MacroPoint convertCriticalAction(CriticalFunction function) {
        MacroPointCriticalSection macroPoint = new MacroPointCriticalSection();

        switch (function.getAction()) {
            case BEGIN:
                macroPoint.setFunction(FunctionCriticalSection.BEGIN);
                break;
            case END:
                macroPoint.setFunction(FunctionCriticalSection.END);
                break;
            default:
                LOGGER.warn("Unknown criticalSection action detected: {}", function);
                break;
        }

        return macroPoint;
    }

    protected CriticalFunction convertMacroPointCriticalSection(MacroPointCriticalSection macroPoint) {
        CriticalFunction function = new CriticalFunction();
        switch (macroPoint.getFunction()) {
            case BEGIN:
                function.setAction(CriticalFunctionStatus.BEGIN);
                break;
            case END:
                function.setAction(CriticalFunctionStatus.END);
                break;
            default:
                LOGGER.warn("Unknown criticalSection action detected: {}", macroPoint);
                break;
        }
        return function;
    }

    protected MacroPoint convertAccessoryAction(AccessoryOkayFunction function) {
        MacroPointAccessoryNotification macroPoint = new MacroPointAccessoryNotification();

        switch (function.getAction()) {
            case QUERY0:
                macroPoint.setFunction(FunctionAccessoryNotification.OKAY_IF_INPUT_0);
                macroPoint.setInputNumber(function.getInput().getId());
                break;
            case QUERY1:
                macroPoint.setFunction(FunctionAccessoryNotification.OKAY_IF_INPUT_1);
                macroPoint.setInputNumber(function.getInput().getId());
                break;
            case NO_FEEDBACK:
                macroPoint.setFunction(FunctionAccessoryNotification.OKAY);
                break;
            default:
                LOGGER.warn("Unknown accessoryOkay action detected: {}", function.getAction());
                break;
        }

        return macroPoint;
    }

    protected AccessoryOkayFunction convertMacroPointAccessoryNotification(
        MacroPointAccessoryNotification macroPoint, List<InputPort> inputPorts) {
        AccessoryOkayFunction function = new AccessoryOkayFunction();
        switch (macroPoint.getFunction()) {
            case OKAY_IF_INPUT_0:
                function.setAction(AccessoryOkayStatus.QUERY0);
                function.setInput(PortListUtils.findPortByPortNumber(inputPorts, macroPoint.getInputNumber()));
                break;
            case OKAY_IF_INPUT_1:
                function.setAction(AccessoryOkayStatus.QUERY1);
                function.setInput(PortListUtils.findPortByPortNumber(inputPorts, macroPoint.getInputNumber()));
                break;
            case OKAY:
                function.setAction(AccessoryOkayStatus.NO_FEEDBACK);
                break;
        }
        return function;
    }

    protected MacroPoint convertServoMoveQueryAction(ServoMoveQueryFunction function) {
        MacroPointServoMoveQuery macroPoint = new MacroPointServoMoveQuery();
        macroPoint.setOutputNumber(function.getPort().getId());
        return macroPoint;
    }

    protected ServoMoveQueryFunction convertMacroPointServoMoveQuery(
        MacroPointServoMoveQuery macroPoint, List<ServoPort> servoPorts) {

        ServoMoveQueryFunction function = new ServoMoveQueryFunction();
        function.setPort(PortListUtils.findPortByPortNumber(servoPorts, macroPoint.getOutputNumber()));
        return function;
    }

    protected MacroPoint convertServoPortAction(ServoPortAction action) {

        MacroPointOutputServo macroPoint = new MacroPointOutputServo();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(action.getPort().getId());
        macroPoint.setPosition(action.getValue());

        return macroPoint;
    }

    protected ServoPortAction convertMacroPointOutputServo(
        MacroPointOutputServo macroPoint, List<ServoPort> servoPorts) {
        ServoPortAction action = new ServoPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(servoPorts, macroPoint.getOutputNumber()));
        action.setValue(macroPoint.getPosition());
        return action;
    }

    protected MacroPoint convertSwitchPortAction(SwitchPortAction action) {

        MacroPointOutputSwitch macroPoint = new MacroPointOutputSwitch();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(action.getPort().getId());

        switch (action.getAction()) {
            case OFF:
                macroPoint.setFunction(FunctionOutputSwitch.OFF);
                break;
            case ON:
                macroPoint.setFunction(FunctionOutputSwitch.ON);
                break;
            default:
                LOGGER.warn("Unknown switchport action detected: {}", action.getAction());
                break;
        }
        return macroPoint;
    }

    protected SwitchPortAction convertMacroPointOutputSwitch(
        MacroPointOutputSwitch macroPoint, List<SwitchPort> switchPorts) {
        SwitchPortAction action = new SwitchPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(switchPorts, macroPoint.getOutputNumber()));
        switch (macroPoint.getFunction()) {
            case OFF:
                action.setAction(SwitchPortStatus.OFF);
                break;
            case ON:
                action.setAction(SwitchPortStatus.ON);
                break;
            default:
                LOGGER.warn("Unknown switchport action detected: {}", macroPoint);
                break;
        }
        return action;
    }

    protected MacroPoint convertSwitchPairPortAction(SwitchPairPortAction action) {

        MacroPointOutputSwitchPair macroPoint = new MacroPointOutputSwitchPair();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(action.getPort().getId());

        switch (action.getAction()) {
            case OFF:
                macroPoint.setFunction(FunctionOutputSwitch.OFF);
                break;
            case ON:
                macroPoint.setFunction(FunctionOutputSwitch.ON);
                break;
            default:
                LOGGER.warn("Unknown switchPairPort action detected: {}", action.getAction());
                break;
        }
        return macroPoint;
    }

    protected SwitchPairPortAction convertMacroPointOutputSwitchPair(
        MacroPointOutputSwitchPair macroPoint, List<SwitchPairPort> switchPairPorts) {
        SwitchPairPortAction action = new SwitchPairPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(switchPairPorts, macroPoint.getOutputNumber()));
        switch (macroPoint.getFunction()) {
            case OFF:
                action.setAction(SwitchPortStatus.OFF);
                break;
            case ON:
                action.setAction(SwitchPortStatus.ON);
                break;
            default:
                LOGGER.warn("Unknown switchPairPort action detected: {}", macroPoint);
                break;
        }
        return action;
    }

    protected MacroPoint convertLightPortAction(LightPortAction action) {
        MacroPointOutputLight macroPoint = new MacroPointOutputLight();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(action.getPort().getId());

        switch (action.getAction()) {
            case BLINKA:
                macroPoint.setFunction(FunctionOutputLight.BLINK_A);
                break;
            case BLINKB:
                macroPoint.setFunction(FunctionOutputLight.BLINK_B);
                break;
            case DOUBLEFLASH:
                macroPoint.setFunction(FunctionOutputLight.DOUBLE_FLASH);
                break;
            case DOWN:
                macroPoint.setFunction(FunctionOutputLight.DIM_DOWN);
                break;
            case FLASHA:
                macroPoint.setFunction(FunctionOutputLight.FLASH_A);
                break;
            case FLASHB:
                macroPoint.setFunction(FunctionOutputLight.FLASH_B);
                break;
            case NEON:
                macroPoint.setFunction(FunctionOutputLight.NEON_FLICKER);
                break;
            case OFF:
                macroPoint.setFunction(FunctionOutputLight.TURN_OFF);
                break;
            case ON:
                macroPoint.setFunction(FunctionOutputLight.TURN_ON);
                break;
            case UP:
                macroPoint.setFunction(FunctionOutputLight.DIM_UP);
                break;
            default:
                LOGGER.warn("Unknown lightport action detected: {}", action.getAction());
                break;
        }

        return macroPoint;
    }

    protected LightPortAction convertMacroPointOutputLight(
        MacroPointOutputLight macroPoint, List<LightPort> lightPorts) {
        LightPortAction action = new LightPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(lightPorts, macroPoint.getOutputNumber()));
        switch (macroPoint.getFunction()) {
            case BLINK_A:
                action.setAction(LightPortStatus.BLINKA);
                break;
            case BLINK_B:
                action.setAction(LightPortStatus.BLINKB);
                break;
            case DOUBLE_FLASH:
                action.setAction(LightPortStatus.DOUBLEFLASH);
                break;
            case DIM_DOWN:
                action.setAction(LightPortStatus.DOWN);
                break;
            case FLASH_A:
                action.setAction(LightPortStatus.FLASHA);
                break;
            case FLASH_B:
                action.setAction(LightPortStatus.FLASHB);
                break;
            case NEON_FLICKER:
                action.setAction(LightPortStatus.NEON);
                break;
            case TURN_OFF:
                action.setAction(LightPortStatus.OFF);
                break;
            case TURN_ON:
                action.setAction(LightPortStatus.ON);
                break;
            case DIM_UP:
                action.setAction(LightPortStatus.UP);
                break;
            default:
                LOGGER.warn("Unknown lightport action detected: {}", macroPoint);
                break;
        }
        return action;
    }

    protected MacroPoint convertBacklightPortAction(BacklightPortAction action) {
        MacroPointOutputBacklight macroPoint = new MacroPointOutputBacklight();
        macroPoint.setDelay(action.getDelay());
        macroPoint.setOutputNumber(action.getPort().getId());
        macroPoint.setBrightness(action.getValue());

        return macroPoint;
    }

    protected BacklightPortAction convertMacroPointOutputBacklight(
        MacroPointOutputBacklight macroPoint, List<BacklightPort> backlightPorts) {
        BacklightPortAction action = new BacklightPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(backlightPorts, macroPoint.getOutputNumber()));
        action.setValue(macroPoint.getBrightness());
        return action;
    }

    protected MacroPoint convertAnalogPortAction(AnalogPortAction function) {
        MacroPointOutputAnalog macroPoint = new MacroPointOutputAnalog();
        macroPoint.setDelay(function.getDelay());
        macroPoint.setOutputNumber(function.getPort().getId());

        return macroPoint;
    }

    protected AnalogPortAction convertMacroPointOutputAnalog(
        MacroPointOutputAnalog macroPoint, List<AnalogPort> analogPorts) {
        AnalogPortAction action = new AnalogPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(analogPorts, macroPoint.getOutputNumber()));

        return action;
    }

    protected MacroPoint convertMotorPortAction(MotorPortAction function) {
        MacroPointOutputMotor macroPoint = new MacroPointOutputMotor();
        macroPoint.setDelay(function.getDelay());
        macroPoint.setOutputNumber(function.getPort().getId());
        switch (function.getAction()) {
            case FORWARD:
                macroPoint.setDirection(DirectionType.FORWARD);
                break;
            case BACKWARD:
                macroPoint.setDirection(DirectionType.BACKWARD);
                break;
            default:
                LOGGER.warn("Unknown lightport action detected: {}", function.getAction());
                break;
        }

        return macroPoint;
    }

    protected MotorPortAction convertMacroPointOutputMotor(
        MacroPointOutputMotor macroPoint, List<MotorPort> motorPorts) {
        MotorPortAction action = new MotorPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(motorPorts, macroPoint.getOutputNumber()));
        switch (macroPoint.getDirection()) {
            case FORWARD:
                action.setAction(MotorPortStatus.FORWARD);
                break;
            case BACKWARD:
                action.setAction(MotorPortStatus.BACKWARD);
                break;
            default:
                LOGGER.warn("Unknown lightport action detected: {}", macroPoint);
                break;
        }
        return action;
    }

    protected MacroPoint convertSoundPortAction(SoundPortAction function) {
        MacroPointOutputSound macroPoint = new MacroPointOutputSound();
        macroPoint.setDelay(function.getDelay());
        macroPoint.setOutputNumber(function.getPort().getId());

        return macroPoint;
    }

    protected SoundPortAction convertMacroPointOutputSound(
        MacroPointOutputSound macroPoint, List<SoundPort> soundPorts) {
        SoundPortAction action = new SoundPortAction();
        action.setDelay(macroPoint.getDelay());
        action.setPort(PortListUtils.findPortByPortNumber(soundPorts, macroPoint.getOutputNumber()));

        return action;
    }
}
