/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.list.SelectionInList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.wizard.PushToMouseWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoListMenu
extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoListMenu.class);
    private JMenuItem pushToMouseItem;
    private JMenuItem openLocoDialog;
    private JMenuItem openPomDialog;
    private final SelectionInList<LocoListModel> locoSelection;
    private final LocoTableControllerListener locoTableController;
    private final LocoTableModel locoTableModel;
    private final Component parent;

    public LocoListMenu(Component parent, LocoTableControllerListener locoTableController, SelectionInList<LocoListModel> locoSelection, LocoTableModel locoTableModel) {
        this.parent = parent;
        this.locoTableController = locoTableController;
        this.locoSelection = locoSelection;
        this.locoTableModel = locoTableModel;
        this.openLocoDialog = new JMenuItem(Resources.getString(LocoListMenu.class, (String)"openLocoDialog") + " ...");
        this.openLocoDialog.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.openLocoDialog);
        this.openPomDialog = new JMenuItem(Resources.getString(LocoListMenu.class, (String)"openPomDialog") + " ...");
        this.openPomDialog.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.openPomDialog);
        this.pushToMouseItem = new JMenuItem(Resources.getString(this.getClass(), (String)"pushToMouse") + " ...");
        this.pushToMouseItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.pushToMouseItem);
    }

    private void fireOpenLocoDialog(LocoListModel locoModel) {
        this.locoTableController.openLocoDialog(locoModel);
    }

    private void fireOpenPomDialog(LocoListModel locoModel) {
        this.locoTableController.openPomDialog(locoModel);
    }

    private void firePushToMouse(ActionEvent e) {
        PushToMouseWizard nodeScriptWizard = new PushToMouseWizard();
        nodeScriptWizard.showWizard(this.locoTableController, this.locoTableModel);
    }
}

