/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.core.SingleObserver;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.exception.NoAnswerException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.model.loco.listener.LocoModelListener;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.RfBasisMode;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.loco.model.SpeedometerModel;
import org.bidib.wizard.mvc.loco.model.command.PomRequestProcessor;
import org.bidib.wizard.mvc.loco.model.command.SpeedometerPomCommand;
import org.bidib.wizard.mvc.loco.view.PomProgrammerRequestListener;
import org.bidib.wizard.mvc.main.controller.LocoPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.LocoPanelView;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocoPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoPanelController.class);
    private final MainModel mainModel;
    private final LocoModel locoModel = new LocoModel();
    private final SpeedometerModel speedometerModel = new SpeedometerModel();
    private LocoModelListener locoModelListener;
    private LocoPanelView locoPanelView;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConsoleService consoleService;
    private MessageAdapter messageAdapter;
    private final ScheduledExecutorService pomRequestProcessorWorker;

    public LocoPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.pomRequestProcessorWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("pomRequestProcessorWorkers-thread-%d").build());
    }

    public LocoPanelView createPanel() {
        NodeInterface node = this.mainModel.getSelectedNode();
        LOGGER.info("Create the LocoView panel, selected node: {}", (Object)node);
        if (node != null) {
            if (ProductUtils.isRFBasisNode((long)node.getUniqueId()) || ProductUtils.isSpeedometer((long)node.getUniqueId())) {
                LOGGER.info("The default speed steps for the decoders on the RF Basis Node or Speedometer is 128.");
                this.locoModel.setSpeedSteps(SpeedSteps.DCC128);
                this.locoModel.setCarControlEnabled(true);
            } else {
                this.locoModel.setSpeedSteps(SpeedSteps.DCC128);
                this.locoModel.setCarControlEnabled(false);
            }
        } else {
            LOGGER.info("No node selected while create the LocoView panel. Do not initialize the speed steps.");
        }
        this.messageAdapter = new /* Unavailable Anonymous Inner Class!! */;
        LOGGER.info("Set the node in the messageAdapter: {}", (Object)node);
        this.messageAdapter.setNode(node);
        SwingUtilities.invokeLater(() -> this.messageAdapter.start());
        2 pomProgrammerRequestListener = new /* Unavailable Anonymous Inner Class!! */;
        this.locoPanelView = new LocoPanelView(this.locoModel, this.speedometerModel, (PomProgrammerRequestListener)pomProgrammerRequestListener, this.settingsService);
        this.locoModelListener = new /* Unavailable Anonymous Inner Class!! */;
        this.locoModel.addLocoModelListener(this.locoModelListener);
        this.locoModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.speedometerModel.addPropertyChangeListener("speedMeasurementStage", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.locoPanelView;
    }

    private void triggerSetMotorPID(NodeInterface selectedNode) {
        LOGGER.info("Set the motor PID values.");
    }

    private void triggerMeasurement(NodeInterface selectedNode, Integer scale, boolean activate, boolean sendMaxSpeed) {
        LOGGER.info("Trigger the measurement, scale: {}, activate: {}", (Object)scale, (Object)activate);
        ArrayList<ConfigurationVariable> cvList = new ArrayList<ConfigurationVariable>();
        cvList.add(new ConfigurationVariable("Scale", scale != null ? scale.toString() : "-1"));
        cvList.add(new ConfigurationVariable("SpeedMeasurement", activate ? "MS 1" : "MS 0"));
        LOGGER.info("Prepared cvList to send: {}", cvList);
        List configVars = this.nodeService.setConfigVariables("main", selectedNode, cvList);
        LOGGER.info("Returned configVars: {}", (Object)configVars);
        if (activate && sendMaxSpeed) {
            LOGGER.info("Activate sets the new stage to SET_SPEED_MAX.");
            SwingUtilities.invokeLater(() -> this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.SET_SPEED_MAX));
        }
    }

    private void triggerSpeedRequest(int speed) {
        LOGGER.info("Set the speed to: {}", (Object)speed);
        try {
            this.locoModel.setSpeed(Integer.valueOf(speed));
            this.locoPanelView.addLogMessage("Set the speed value to {}.", new Object[]{speed});
        }
        catch (NoAnswerException ex) {
            LOGGER.warn("Set speed failed.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.warn("Set speed failed.", (Throwable)ex);
        }
    }

    private void updatePomProgState(PomProgState pomProgState, PomAddressData decoderAddress, int cvNumber, int cvValue) {
        if (this.speedometerModel != null) {
            PomProgrammerModel pomProgrammerModel = this.speedometerModel.getPomProgrammerModel();
            if (pomProgrammerModel != null) {
                pomProgrammerModel.updatePomProgResult(pomProgState, decoderAddress, cvNumber, cvValue);
            } else {
                LOGGER.warn("No pomProgrammerModel available in speedoMeterModel.");
            }
        }
    }

    private void changeLightsAndSpeed(CommandStationNodeInterface selectedNode, boolean lightsOn) {
        LOGGER.info("Change the lights value and set speed to 0, lightsOn: {}", (Object)lightsOn);
        if (this.locoModel.getAddress() == null) {
            LOGGER.warn("No address available.");
            return;
        }
        int functionGroupIndex = 0;
        BitSet activeFunctions = new BitSet(functionGroupIndex + 1);
        activeFunctions.set(functionGroupIndex, true);
        BitSet functions = new BitSet(29);
        functions.set(0, lightsOn ? 1 : 0);
        Integer speed = 0;
        DefaultContext context = new DefaultContext();
        this.registerActiveRfBasis((Context)context);
        this.commandStationService.setSpeed("main", selectedNode, this.locoModel.getAddress().intValue(), this.locoModel.getSpeedSteps(), speed, DirectionStatus.FORWARD, activeFunctions, functions, (Context)context);
    }

    private void waitBetweenCommands(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait between commands was interrupted.", (Throwable)ex);
        }
    }

    private void fireReadCvValues() {
        LOGGER.info("Read the values from the decoder.");
        ArrayList<SpeedometerPomCommand> pomProgCommands = new ArrayList<SpeedometerPomCommand>();
        Integer dccAddress = this.locoModel.getAddress();
        LOGGER.info("Prepared DCC address: {}", (Object)dccAddress);
        if (dccAddress == null) {
            LOGGER.warn("No dccAddress available.");
            return;
        }
        PomAddressData addressData = new PomAddressData(dccAddress.intValue(), PomAddressTypeEnum.LOCOMOTIVE);
        LOGGER.info("Prepared addressData for CV read: {}", (Object)addressData);
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 2, (int)ByteUtils.getLowByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 5, (int)ByteUtils.getLowByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 37, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 111, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 35, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 36, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 59, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 111, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 61, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 62, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 63, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 7, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 109, (int)ByteUtils.getHighByte((int)0)));
        pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.RD_BYTE, 110, (int)ByteUtils.getHighByte((int)0)));
        SingleObserver completeAction = this.speedometerModel.getCompleteAction();
        this.speedometerModel.setCompleteAction(null);
        PomRequestProcessor pomRequestProcessor = this.speedometerModel.getPomRequestProcessor();
        this.pomRequestProcessorWorker.schedule(() -> pomRequestProcessor.submitProgCommands(pomProgCommands, completeAction), 0L, TimeUnit.MILLISECONDS);
    }

    private void fireWriteCvValues() {
        LOGGER.info("Write the values to the decoder.");
        List pomProgCommands = this.speedometerModel.getPomProgCommands();
        this.speedometerModel.setPomProgCommands(null);
        SingleObserver completeAction = this.speedometerModel.getCompleteAction();
        this.speedometerModel.setCompleteAction(null);
        LOGGER.info("Current pomProgCommands: {}", (Object)pomProgCommands);
        PomRequestProcessor pomRequestProcessor = this.speedometerModel.getPomRequestProcessor();
        this.pomRequestProcessorWorker.schedule(() -> pomRequestProcessor.submitProgCommands(pomProgCommands, completeAction), 0L, TimeUnit.MILLISECONDS);
    }

    private void registerActiveRfBasis(Context context) {
        if (this.locoModel.isCarControlEnabled() && this.locoModel.getActiveBase() != null) {
            RfBasisMode activeRfBase = this.locoModel.getActiveBase();
            if (activeRfBase.getBaseNumber() != null) {
                int activeBaseNumber = activeRfBase.getBaseNumber();
                NodeInterface rfBasisNode = this.mainModel.getNodeProvider().getNodes().stream().filter(bidibNode -> ProductUtils.isRFBasisNode((long)bidibNode.getUniqueId()) && bidibNode.getBaseNumber() == activeBaseNumber).findFirst().orElse(null);
                if (rfBasisNode != null) {
                    LOGGER.info("Found the active rfBasisNode: {}", (Object)rfBasisNode);
                    context.register("activeRfBasis", (Object)rfBasisNode.getNode());
                } else {
                    LOGGER.warn("No active rfBasisNode found for activeBaseNumber: {}", (Object)activeBaseNumber);
                }
            } else {
                LOGGER.info("No base number for active rf base available.");
            }
        }
    }
}

