/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view;

import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStoreEntry;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.preferences.view.panel.SettingsPanelInterface;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.preferences.model.PairingStoreEntryModel;
import org.bidib.wizard.mvc.preferences.model.PairingStoreModel;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.bidib.wizard.mvc.preferences.view.listener.PreferencesViewListener;
import org.bidib.wizard.mvc.preferences.view.panel.ConnectionPanel;
import org.bidib.wizard.mvc.preferences.view.panel.ExperimentalSettingsPanel;
import org.bidib.wizard.mvc.preferences.view.panel.MiscSettingsPanel;
import org.bidib.wizard.mvc.preferences.view.panel.NetBidibSettingsPanel;
import org.bidib.wizard.mvc.preferences.view.panel.PairingStoreSettingsPanel;
import org.bidib.wizard.mvc.preferences.view.panel.TimePanel;
import org.bidib.wizard.mvc.preferences.view.panel.WizardSettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesView
extends EscapeDialog {
    private static final long serialVersionUID = -1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesView.class);
    private final Collection<PreferencesViewListener> listeners = new LinkedList();
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:p, 3dlu, p, fill:3dlu:grow";
    private final ConnectionPanel connectionPanel;
    private final MiscSettingsPanel miscPanel;
    private final TimePanel timePanel;
    private final WizardSettingsPanel wizardSettingsPanel;
    private final ExperimentalSettingsPanel experimentalSettingsPanel;
    private final NetBidibSettingsPanel netBidibSettingsPanel;
    private final PairingStoreSettingsPanel pairingStoreSettingsPanel;
    private final PairingStoreModel pairingStoreModel;
    private final JTabbedPane tabbedPane;
    private final JButton saveButton;
    private final JButton cancelButton;
    private ValueModel saveButtonEnabled = new ValueHolder();
    private final PreferencesModel model;
    private final List<SettingsPanelInterface> settingsPanelInterfaces;
    private final JFrame parent;

    public PreferencesView(JFrame parent, PreferencesModel model, List<SettingsPanelInterface> settingsPanelInterfaces) {
        super((Frame)parent, Resources.getString(PreferencesView.class, (String)"title"), true);
        Object panel;
        this.parent = parent;
        this.model = model;
        this.settingsPanelInterfaces = settingsPanelInterfaces;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.saveButton = new JButton(Resources.getString(this.getClass(), (String)"save"));
        this.saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.saveButton.setEnabled(false);
        this.cancelButton = new JButton(Resources.getString(this.getClass(), (String)"cancel"));
        this.cancelButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabbedPane = new JTabbedPane();
        Consumer<Boolean> bufferingCallback = isBuffering -> this.bufferingChanged();
        GlobalSettingsInterface globalSettings = model.getGlobalSettings();
        WizardSettingsInterface wizardSettings = model.getWizardSettings();
        MiscSettingsInterface miscSettings = model.getMiscSettings();
        ExperimentalSettingsInterface experimentalSettings = model.getExperimentalSettings();
        NetBidibSettingsInterface netBidibSettings = model.getNetBidibSettings();
        if (StringUtils.isBlank((CharSequence)netBidibSettings.getPairingStoreLocation())) {
            String pairingStoreLocation = new File(miscSettings.getBidibConfigDir(), "/data/netBiDiB").getPath();
            LOGGER.info("Set the default location of the pairing store: {}", (Object)pairingStoreLocation);
            netBidibSettings.setPairingStoreLocation(pairingStoreLocation);
        }
        this.connectionPanel = new ConnectionPanel(model, globalSettings, wizardSettings, bufferingCallback);
        this.miscPanel = new MiscSettingsPanel(model, miscSettings, bufferingCallback);
        this.wizardSettingsPanel = new WizardSettingsPanel(model, wizardSettings, bufferingCallback);
        this.experimentalSettingsPanel = new ExperimentalSettingsPanel(experimentalSettings, bufferingCallback);
        this.netBidibSettingsPanel = new NetBidibSettingsPanel(netBidibSettings, bufferingCallback);
        PairingStore pairingStore = model.getPairingStore();
        this.pairingStoreModel = new PairingStoreModel();
        for (PairingStoreEntry entry : pairingStore.getPairingStoreEntries()) {
            PairingStoreEntryModel entryModel = new PairingStoreEntryModel();
            entryModel.setUid(entry.getUid());
            entryModel.setRequestorName(entry.getRequestorName());
            entryModel.setProductName(entry.getProductName());
            entryModel.setUserName(entry.getUserName());
            if (entry.getProtocolVersion() != null) {
                entryModel.setProtocolVersion(entry.getProtocolVersion().toProtocolVersion());
            }
            entryModel.setLastSeen(entry.getLastSeen());
            entryModel.setPaired(entry.isPaired());
            this.pairingStoreModel.addPairing(entryModel);
        }
        this.pairingStoreSettingsPanel = new PairingStoreSettingsPanel(this.pairingStoreModel, bufferingCallback);
        this.timePanel = new TimePanel(model, globalSettings, bufferingCallback);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-connection"), null, this.connectionPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-connection.tooltip"));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-wizardsettings"), null, this.wizardSettingsPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-wizardsettings.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-misc"), null, this.miscPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-misc.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 51);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-time"), null, this.timePanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-time.tooltip"));
        this.tabbedPane.setMnemonicAt(2, 52);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-experimentalsettings"), null, this.experimentalSettingsPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-experimentalsettings.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 53);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-netbidibsettings"), null, this.netBidibSettingsPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-netbidibsettings.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 54);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-pairingstoresettings"), null, this.pairingStoreSettingsPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-pairingstoresettings.tooltip"));
        this.tabbedPane.setMnemonicAt(1, 55);
        for (SettingsPanelInterface settingsPanelInterface : settingsPanelInterfaces) {
            LOGGER.info("Add settings panel: {}", (Object)settingsPanelInterface);
            this.tabbedPane.addTab(settingsPanelInterface.getTabTitle(), null, settingsPanelInterface.createPanel(bufferingCallback), settingsPanelInterface.getTabTooltip());
        }
        dialogBuilder.add((Component)this.tabbedPane).xyw(1, 1, 3);
        JPanel buttons = ((ButtonBarBuilder)new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.saveButton, this.cancelButton}).border((Border)Paddings.DLU4)).build();
        dialogBuilder.add((Component)buttons).xyw(1, 3, 3);
        JPanel contentPanel = dialogBuilder.build();
        PropertyConnector.connect((Object)this.saveButtonEnabled, (String)"value", (Object)this.saveButton, (String)"enabled");
        this.getContentPane().add(contentPanel);
        this.netBidibSettingsPanel.flushBuffer();
        this.connectionPanel.flushBuffer();
        this.experimentalSettingsPanel.flushBuffer();
        this.miscPanel.flushBuffer();
        this.wizardSettingsPanel.flushBuffer();
        this.timePanel.flushBuffer();
        this.pairingStoreSettingsPanel.flushBuffer();
        for (SettingsPanelInterface settingsPanelInterface : this.settingsPanelInterfaces) {
            settingsPanelInterface.flushBuffer();
        }
    }

    public void showView() {
        this.pack();
        this.setLocationRelativeTo((Component)this.parent);
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    private void bufferingChanged() {
        LOGGER.info("bufferingChanged.");
        boolean isBuffering = this.netBidibSettingsPanel.isBuffering() || this.connectionPanel.isBuffering() || this.experimentalSettingsPanel.isBuffering() || this.miscPanel.isBuffering() || this.wizardSettingsPanel.isBuffering() || this.timePanel.isBuffering() || this.pairingStoreSettingsPanel.isBuffering();
        for (SettingsPanelInterface settingsPanelInterface : this.settingsPanelInterfaces) {
            isBuffering = isBuffering || settingsPanelInterface.isBuffering();
        }
        this.saveButtonEnabled.setValue((Object)isBuffering);
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim.width < 720) {
            dim.width = 720;
        }
        return dim;
    }

    public void addPreferencesViewListener(PreferencesViewListener l) {
        this.listeners.add(l);
    }

    private void fireSave() {
        this.netBidibSettingsPanel.commitBuffer();
        this.connectionPanel.commitBuffer();
        this.experimentalSettingsPanel.commitBuffer();
        this.miscPanel.commitBuffer();
        this.wizardSettingsPanel.commitBuffer();
        this.timePanel.commitBuffer();
        this.pairingStoreSettingsPanel.commitBuffer();
        for (SettingsPanelInterface settingsPanelInterface : this.settingsPanelInterfaces) {
            settingsPanelInterface.commitBuffer();
        }
        PairingStore pairingStore = this.model.getPairingStore();
        LinkedList<PairingStoreEntry> keepEntries = new LinkedList<PairingStoreEntry>();
        for (PairingStoreEntryModel entry : this.pairingStoreModel.getPairings()) {
            String uid = entry.getUid();
            PairingStoreEntry existing = pairingStore.getPairingStoreEntries().stream().filter(e -> e.getUid().equals(uid)).findFirst().orElse(null);
            if (existing == null) continue;
            keepEntries.add(existing);
        }
        pairingStore.clear();
        pairingStore.setPairings(keepEntries);
        for (PreferencesViewListener l : this.listeners) {
            l.save();
        }
    }

    private void fireCancel() {
        this.netBidibSettingsPanel.flushBuffer();
        this.connectionPanel.flushBuffer();
        this.experimentalSettingsPanel.flushBuffer();
        this.miscPanel.flushBuffer();
        this.wizardSettingsPanel.flushBuffer();
        this.timePanel.flushBuffer();
        this.pairingStoreSettingsPanel.flushBuffer();
        for (SettingsPanelInterface settingsPanelInterface : this.settingsPanelInterfaces) {
            settingsPanelInterface.flushBuffer();
        }
        for (PreferencesViewListener l : this.listeners) {
            l.cancel();
        }
    }
}

