/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.tips.view;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.tipoftheday.TipOfTheDayDialog;
import com.jidesoft.tipoftheday.TipOfTheDaySource;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.Action;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.tips.controller.TipOfDayClosedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TipOfDayView {
    private static final Logger LOGGER = LoggerFactory.getLogger(TipOfDayView.class);

    public void showTipsOfTheDay(DefaultBusyFrame frame, TipOfDayClosedListener listener, SettingsService settingsService, TipOfTheDaySource tipOfTheDaySource) {
        tipOfTheDaySource.setCurrentTipIndex(this.getLastTipOfDayIndex(settingsService.getWizardSettings()));
        URL styleSheet = TipOfTheDayDialog.class.getResource("/tips.css");
        TipOfTheDayDialog dialog = new TipOfTheDayDialog((Frame)frame, tipOfTheDaySource, (Action)new /* Unavailable Anonymous Inner Class!! */, styleSheet);
        dialog.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        dialog.setShowTooltip(this.getPrefBooleanValue(settingsService.getWizardSettings()));
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(false);
        dialog.pack();
        JideSwingUtilities.globalCenterWindow((Window)dialog);
        dialog.setVisible(true);
    }

    private boolean getPrefBooleanValue(WizardSettingsInterface wizardSettings) {
        return wizardSettings.isShowTipOfDay();
    }

    private void setPrefBooleanValue(WizardSettingsInterface wizardSettings, boolean showTipOfDay) {
        wizardSettings.setShowTipOfDay(showTipOfDay);
    }

    private int getLastTipOfDayIndex(WizardSettingsInterface wizardSettings) {
        return wizardSettings.getLastTipOfDayIndex();
    }

    private void setLastTipOfDayIndex(SettingsService settingsService, int currentTipIndex) {
        WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        wizardSettings.setLastTipOfDayIndex(currentTipIndex);
        settingsService.storeSettings();
    }
}

