package org.bidib.wizard.mvc.main.view.table;

import javax.swing.table.TableColumn;

import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.model.SoundPortTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class SoundPortTable extends AbstractPortHierarchicalTable<SoundPort> {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortTable.class);

    private final SoundPortTableModel soundPortTableModel;

    public SoundPortTable(final SoundPortTableModel soundPortTableModel, String emptyTableText) {
        super(soundPortTableModel, emptyTableText);

        this.soundPortTableModel = soundPortTableModel;
    }

    @Override
    public void clearTable() {
    }

    @Override
    protected SoundPortEditorPanel createPortEditorPanel(
        final SoundPort port, int row, final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {

        // the port is the original port from the node

        SoundPortEditorPanel editorPanel =
            new SoundPortEditorPanel(port, soundPort -> this.soundPortTableModel.updatePortConfig(soundPort),
                soundPort -> this.soundPortTableModel.fireTestButtonPressed(soundPort),
                soundPort -> this.soundPortTableModel
                    .refreshRow(soundPort,
                        changedRow -> repaint(getCellRect(changedRow, SoundPortTableModel.COLUMN_LABEL, true))),
                portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(SoundPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new PortConfigErrorAwareRenderer(SoundPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_LABEL));

        // Set the status renderer
        tc = getColumnModel().getColumn(SoundPortTableModel.COLUMN_STATUS);
        tc.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_STATUS));
        tc
            .setCellRenderer(new BidibStatusTableRenderer(SoundPortStatus.class, "status.",
                SoundPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SOUNDPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        tc.setMinWidth(100);
        tc.setMaxWidth(120);

        final TableColumn buttonColumn = getColumnModel().getColumn(SoundPortTableModel.COLUMN_TEST);
        buttonColumn.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_TEST));
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);

        final PortComboBoxWithButtonEditorRenderer<BidibStatus> editor =
            new PortComboBoxWithButtonEditorRenderer<BidibStatus>(getActions(SoundPortStatus.PLAY), ">",
                SoundPortStatus.class, SoundPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SOUNDPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            };
        // editor.addButtonListener(new ButtonListener() {
        //
        // @Override
        // public void buttonPressed(int row, int column, Object value) {
        // LOGGER.info("The test button was pressed, row: {}, column: {}", row, column);
        // getModel().setValueAt(value, row, SoundPortTableModel.COLUMN_TEST);
        // }
        // });

        buttonColumn.setCellEditor(editor);
        buttonColumn.setCellRenderer(editor);

        TableColumnChooser.hideColumn(this, SoundPortTableModel.COLUMN_PORT_INSTANCE);
    }
}
