package org.bidib.wizard.mvc.pom.model.command;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.wizard.mvc.pom.model.DirectAccessProgBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomDirectAccessCommand extends PomOperationCommand<DirectAccessProgBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomDirectAccessCommand.class);

    public PomDirectAccessCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int cvValue) {
        super(decoderAddress, pomOperation, cvNumber, cvValue);
    }

    @Override
    public void postExecute(final DirectAccessProgBeanModel directAccessProgBeanModel) {
        super.postExecute(directAccessProgBeanModel);

        // TODO check if the address and CV number is correct
        // update the railcom config
        if (getCvValueResult() != null) {
            LOGGER.debug("Set the cvValueResult: {}", getCvValueResult());
            directAccessProgBeanModel.setCvValue(getCvValueResult());
        }
    }
}
