/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.AccessorySaveState;
import org.bidib.wizard.api.model.AccessorySwitchTimeModel;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.AccessoryListListener;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.utils.AccessoryListUtils;
import org.bidib.wizard.client.common.view.ComponentUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.AccessoryLabelUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.node.types.AccessoryAspectTargetType;
import org.bidib.wizard.common.script.node.types.AccessoryTargetType;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.common.view.table.DefaultTextCellEditor;
import org.bidib.wizard.mvc.main.controller.AccessoryPanelController;
import org.bidib.wizard.mvc.main.model.AccessoryStartupAspectModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.AccessoryListMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.AccessoryListMenuListener;
import org.bidib.wizard.mvc.main.view.panel.AccessoryListPanel;
import org.bidib.wizard.mvc.main.view.panel.AccessoryPanel;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.mvc.main.view.panel.listener.AccessoryActionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelChangedListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.panel.renderer.AccessoryListRenderer;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlControllerInterface;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryListPanel
implements AccessoryListMenuListener,
AccessoryActionListener,
AccessoryListListener,
ChangeLabelSupport,
TabSelectionListener,
TabPanelProvider,
TabVisibilityProvider,
PendingChangesAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryListPanel.class);
    private final Collection<LabelChangedListener<Accessory>> labelChangedListeners = new LinkedList();
    private final TabVisibilityListener tabVisibilityListener;
    private final MainModel mainModel;
    private final AccessoryPanel accessoryPanel;
    private final JScrollPane scrollAccessoryList;
    private final AccessoryList accessoryList;
    private final AccessoryListMenu accessoryListMenu = new AccessoryListMenu();
    private final DisabledPanel disabledBorderPanel;
    private final JPanel contentPanel;
    private final StatusBar statusBar;
    private JPanel buttonPanel;
    private final AccessoryPanelController accessoryPanelController;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final ConsoleService consoleService;
    private static final String WORKING_DIR_ACCESSORY_EXCHANGE_KEY = "accessoryExchange";

    public AccessoryListPanel(AccessoryPanelController accessoryPanelController, MainModel model, AccessoryStartupAspectModel accessoryStartupAspectModel, AccessorySwitchTimeModel accessorySwitchTimeModel, TabVisibilityListener tabVisibilityListener, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper, StatusBar statusBar, ConsoleService consoleService) {
        this.accessoryPanelController = accessoryPanelController;
        this.mainModel = model;
        this.tabVisibilityListener = tabVisibilityListener;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.consoleService = consoleService;
        this.statusBar = statusBar;
        this.contentPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.accessoryListMenu.addMenuListener((AccessoryListMenuListener)this);
        this.accessoryPanel = new AccessoryPanel(accessoryPanelController, model, accessoryStartupAspectModel, accessorySwitchTimeModel);
        JPanel panel = new JPanel(new BorderLayout());
        this.disabledBorderPanel = new DisabledPanel((Container)this.accessoryPanel);
        panel.add((Component)this.disabledBorderPanel);
        2 tableModel = new /* Unavailable Anonymous Inner Class!! */;
        tableModel.addLabelChangedListener((accessory, label) -> {
            LOGGER.info("The label of the accessory was changed: {}, label: {}", accessory, (Object)label);
            long uniqueId = model.getSelectedNode().getUniqueId();
            accessory.setLabel(label);
            NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(uniqueId));
            AccessoryLabelUtils.replaceAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (String)label);
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        });
        this.accessoryList = new AccessoryList(this, (DefaultTableModel)tableModel, accessory -> {
            this.setEnabled(accessory != null);
            if (this.buttonPanel != null) {
                List buttons = ComponentUtils.harvestComponents((Container)this.buttonPanel, JButton.class);
                for (JButton button : buttons) {
                    button.setEnabled(accessory != null);
                }
            }
        });
        this.accessoryList.adjustRowHeight();
        this.accessoryList.getTableHeader().setReorderingAllowed(false);
        this.accessoryList.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.accessoryList.setSortable(false);
        this.accessoryList.setSelectionMode(0);
        TableColumn tc = this.accessoryList.getColumnModel().getColumn(0);
        tc.setPreferredWidth(80);
        tc.setWidth(80);
        AccessoryListRenderer renderer = new AccessoryListRenderer();
        tc.setCellRenderer((TableCellRenderer)renderer);
        tc.setCellEditor((TableCellEditor)new DefaultTextCellEditor(new JTextField()));
        this.accessoryList.setPreferredScrollableViewportSize(new Dimension(200, 200));
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.accessoryList));
        this.accessoryList.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.accessoryList.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.accessoryList.getEmptyTableText() + ":f:gray}")));
        this.scrollAccessoryList = new JScrollPane((Component)overlayTable);
        JSplitPane splitPane = new JSplitPane(1, this.scrollAccessoryList, panel);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2);
        this.contentPanel.add((Component)splitPane, "Center");
        this.setEnabled(false);
        this.addButtonPanel(panel);
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private void addButtonPanel(JPanel parent) {
        JButton loadButton = new JButton(Resources.getString(this.getClass(), (String)"reload"));
        loadButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton saveButton = new JButton(Resources.getString(this.getClass(), (String)"save"));
        saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonPanel = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{loadButton, saveButton}).build();
        this.buttonPanel.setBorder((Border)Paddings.TABBED_DIALOG);
        parent.add((Component)this.buttonPanel, "South");
        PropertyConnector.connect((Object)this.accessoryPanel.getSaveButtonEnabledModel(), (String)"value", (Object)saveButton, (String)"enabled");
    }

    public void exportAccessory() {
        this.exportAccessory(this.mainModel.getSelectedAccessory());
    }

    public void saveAccessory() {
        this.fireSaveAccessory();
    }

    public void reloadAccessory() {
        this.fireReloadAccessory();
    }

    private void fireReloadAccessory() {
        this.reloadAccessory(this.mainModel.getSelectedAccessory());
    }

    private void fireSaveAccessory() {
        Accessory selectedAccessory = this.mainModel.getSelectedAccessory();
        this.accessoryPanel.saveAccessory(selectedAccessory);
        this.saveAccessory(selectedAccessory);
    }

    public void importAccessory() {
        this.importAccessory(this.mainModel.getSelectedAccessory());
    }

    public void initializeAccessory() {
        try {
            Accessory accessory = this.mainModel.getSelectedAccessory();
            if (accessory != null && accessory.getAccessorySaveState().equals((Object)AccessorySaveState.PENDING_CHANGES)) {
                int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(AccessoryListPanel.class, (String)"accessory_has_pending_changes"), Resources.getString(AccessoryListPanel.class, (String)"pending_changes"), 2);
                if (result != 0) {
                    LOGGER.info("User cancelled discard pending changes.");
                    return;
                }
                this.mainModel.getSelectedAccessory().setAccessorySaveState(AccessorySaveState.PERMANENTLY_STORED_ON_NODE);
            }
            accessory.initialize();
            accessory.setAccessorySaveState(AccessorySaveState.PENDING_CHANGES);
            accessory.setLabel(null);
            this.saveChangedLabel(accessory, null);
            this.mainModel.setSelectedAccessory(accessory);
        }
        catch (Exception ex) {
            LOGGER.warn("Initialize the selected accessory failed.", (Throwable)ex);
        }
    }

    public void setEnabled(boolean enabled) {
        this.disabledBorderPanel.setEnabled(enabled);
    }

    public void changeLabel(TargetType portType) {
        int accessoryNumber = portType.getPortNum();
        String label = portType.getLabel();
        LOGGER.info("Change the label, portType: {}, label: {}", (Object)portType, (Object)label);
        if (portType instanceof AccessoryTargetType) {
            Accessory accessory = AccessoryListUtils.findAccessoryByAccessoryNumber((Iterable)this.mainModel.getAccessories(), (int)accessoryNumber);
            if (accessory != null) {
                LOGGER.info("Current accessory: {}, new label: {}, accessoryNumber: {}", new Object[]{accessory, label, accessoryNumber});
                accessory.setLabel(label);
                this.fireLabelChanged(accessory, label);
            }
        } else if (portType instanceof AccessoryAspectTargetType) {
            AccessoryAspectTargetType aspectTargetType = (AccessoryAspectTargetType)portType;
            this.accessoryPanel.changeLabel(aspectTargetType);
        }
    }

    public void addLabelChangedListener(LabelChangedListener<Accessory> l) {
        this.labelChangedListeners.add(l);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.accessoryList.addListSelectionListener(l);
    }

    protected void fireLabelChanged(Accessory accessory, String label) {
        this.labelChanged(accessory, label);
        this.accessoryList.refreshView();
        for (LabelChangedListener l : this.labelChangedListeners) {
            l.labelChanged((Object)accessory, label);
        }
    }

    protected void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger() && this.accessoryList.getRowCount() > 0) {
            if (this.accessoryList.getCellEditor() != null) {
                this.accessoryList.getCellEditor().stopCellEditing();
            }
            int selectRow = this.accessoryList.rowAtPoint(e.getPoint());
            this.accessoryList.setRowSelectionInterval(selectRow, selectRow);
            Accessory accessory = this.accessoryList.getSelectedItem();
            if (accessory != null && ProductUtils.isStepControl((long)this.mainModel.getSelectedNode().getUniqueId())) {
                if (accessory.getId() < 3) {
                    popupMenu.setEnabled(false);
                } else {
                    popupMenu.setEnabled(true);
                }
            } else {
                popupMenu.setEnabled(true);
            }
            SwingUtilities.invokeLater(() -> popupMenu.show(e.getComponent(), e.getX(), e.getY()));
        }
    }

    public void tabSelected(boolean selected) {
        long uniqueId;
        boolean isStepControl;
        LOGGER.info("Tab is selected: {}", (Object)selected);
        if (selected && this.accessoryList.getCellEditor() != null) {
            this.accessoryList.getCellEditor().stopCellEditing();
        }
        if (selected && this.mainModel.getSelectedNode() != null && (isStepControl = ProductUtils.isStepControl((long)(uniqueId = this.mainModel.getSelectedNode().getUniqueId())))) {
            LOGGER.info("The current node is a StepControl. Trigger load of CV values.");
            try {
                StepControlControllerInterface controller = (StepControlControllerInterface)DefaultApplicationContext.getInstance().get("stepControlController", StepControlControllerInterface.class);
                controller.triggerLoadCvValues();
            }
            catch (Exception ex) {
                LOGGER.warn("Trigger load CV values of StepControl failed.", (Throwable)ex);
            }
        }
    }

    public void exportAccessory(Accessory accessory) {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_ACCESSORY_EXCHANGE_KEY);
        7 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void importAccessory(Accessory accessory) {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_ACCESSORY_EXCHANGE_KEY);
        8 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void labelChanged(Accessory accessory, String label) {
        this.saveChangedLabel(accessory, label);
    }

    private void saveChangedLabel(Accessory accessory, String label) {
        if (accessory != null) {
            LOGGER.info("Save the changed label, accessory: {}, new label: {}", (Object)accessory, (Object)label);
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(uniqueId));
            AccessoryLabelUtils.replaceAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (String)label);
            try {
                this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
            }
            catch (Exception e) {
                LOGGER.warn("Save accessory labels failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void reloadAccessory(Accessory accessory) {
        if (accessory != null && AccessorySaveState.PERMANENTLY_STORED_ON_NODE != accessory.getAccessorySaveState()) {
            int result = JOptionPane.showConfirmDialog(this.getComponent(), Resources.getString(AccessoryListPanel.class, (String)"accessory_has_pending_changes"), Resources.getString(AccessoryListPanel.class, (String)"pending_changes"), 2);
            if (result != 0) {
                LOGGER.info("User canceled discard pending changes.");
                return;
            }
            accessory.setAccessorySaveState(AccessorySaveState.PERMANENTLY_STORED_ON_NODE);
        }
        this.accessoryPanelController.reloadAccessory(accessory);
        accessory.setAccessorySaveState(AccessorySaveState.PERMANENTLY_STORED_ON_NODE);
    }

    public void saveAccessory(Accessory accessory) {
        LOGGER.info("Save the accessory: {}", (Object)accessory);
        this.accessoryPanelController.storeAccessory(accessory);
    }

    public boolean equals(Object other) {
        return other instanceof AccessoryListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasAccessories();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public void accessoryChanged(Integer accessoryId) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAccessoryChanged(accessoryId);
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void internalAccessoryChanged(Integer accessoryId) {
        Accessory accessory = this.mainModel.getSelectedAccessory();
        this.setEnabled(accessory != null);
        if (this.buttonPanel != null) {
            List buttons = ComponentUtils.harvestComponents((Container)this.buttonPanel, JButton.class);
            for (JButton button : buttons) {
                button.setEnabled(accessory != null);
            }
        }
    }

    public void listChanged() {
        LOGGER.info("Accessory list has been changed.");
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalListChanged();
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void internalListChanged() {
        LOGGER.info("Process internal accessory list has been changed.");
        this.mainModel.setSelectedAccessory(null);
        ArrayList accessories = new ArrayList();
        accessories.addAll(this.mainModel.getAccessories());
        Collections.sort(accessories, new /* Unavailable Anonymous Inner Class!! */);
        this.accessoryList.setItems(accessories.toArray(new Accessory[0]));
        this.accessoryList.refreshView();
        this.resetAccessoryScrollPane();
        this.setEnabled(false);
        this.tabVisibilityListener.setTabVisible((Component)this.getComponent(), this.isTabVisible());
    }

    private void resetAccessoryScrollPane() {
        JScrollBar verticalScrollBar = this.scrollAccessoryList.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.scrollAccessoryList.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
    }

    public void pendingChangesChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.accessoryList.refreshView();
        } else {
            SwingUtilities.invokeLater(() -> this.accessoryList.refreshView());
        }
    }

    public boolean hasPendingChanges() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            List accessories = node.getAccessories();
            for (Accessory accessory : accessories) {
                if (AccessorySaveState.PENDING_CHANGES != accessory.getAccessorySaveState()) continue;
                LOGGER.info("Found pending changes in accessory: {}", (Object)accessory);
                return true;
            }
        }
        return false;
    }

    public void savePendingChanges() {
        LOGGER.info("Save the pending changes.");
    }

    public void editLabel(MouseEvent popupEvent) {
        SwingUtilities.invokeLater(() -> {
            int selectedRow = this.accessoryList.getSelectedRow();
            if (selectedRow > -1) {
                LOGGER.info(">>> Edit row, selectedRow: {}", (Object)selectedRow);
                this.accessoryList.requestFocus();
                this.accessoryList.editCellAt(selectedRow, 0);
                TableCellEditor editor = this.accessoryList.getCellEditor();
                if (editor instanceof DefaultTextCellEditor) {
                    SwingUtilities.invokeLater(() -> {
                        JTextField textField = (JTextField)((DefaultTextCellEditor)editor).getComponent();
                        LOGGER.info("Request focus in textField: {}", (Object)textField);
                        textField.requestFocusInWindow();
                    });
                }
            }
        });
    }

    public void refreshView() {
        this.accessoryList.refreshView();
        this.accessoryPanel.refreshView();
    }

    public void handleStringChanged(int index, String value) {
        this.accessoryPanel.handleStringChanged(index, value);
    }
}

