package org.bidib.wizard.mvc.main.view.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.SoundPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractHierarchicalEmptyTable.PackLastColumnEnum;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.controller.SoundPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SoundPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SoundPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.SoundPortTable;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class SoundPortListPanel
    extends
    SimpleHierarchicalPortListPanel<SoundPortTableModel, SoundPortStatus, SoundPort, SoundPortListener, SoundPortModelListener>
    implements TabVisibilityProvider, TabPanelProvider, TabComponentCreator {
    private static final long serialVersionUID = 1L;

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    // private final class PortIntegerEditor extends IntegerEditor {
    // private static final long serialVersionUID = 1L;
    //
    // private int forColumn;
    //
    // public PortIntegerEditor(int min, int max, int forColumn) {
    // super(min, max);
    // this.forColumn = forColumn;
    // }
    //
    // @Override
    // public Component getTableCellEditorComponent(
    // JTable table, Object value, boolean isSelected, int row, int column) {
    // if (value instanceof SoundPort) {
    // SoundPort soundPort = (SoundPort) value;
    // LOGGER.debug("get editor, forColumn: {}, column: {}", forColumn, column);
    // switch (forColumn) {
    // default:
    // value = soundPort.getPulseTime();
    // break;
    // }
    // }
    //
    // return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    // }
    // }

    public SoundPortListPanel(final SoundPortPanelController controller, final SoundPortTableModel tableModel,
        final MainModel mainModel, final TabVisibilityListener tabVisibilityListener,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(SoundPortListPanel.class, "emptyTable"), portConfigChangeEventSubject,
            mainModel);

        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;

    }

    @Override
    protected AbstractPortHierarchicalTable<SoundPort> createPortTable(
        SoundPortTableModel tableModel, String emptyTableText) {

        return new SoundPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(
        final SoundPortTableModel tableModel, String emptyTableText,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {

        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);

        // create the portlist menu listener to handle the port menu
        final PortListMenuListener portListMenuListener =
            createPortListMenuListener(this.table, nodeSelectionProvider, null);
        table.setPortListMenuListener(portListMenuListener);

    }

    // TableColumn tc = table.getColumnModel().getColumn(SoundPortTableModel.COLUMN_LABEL);
    // tc.setCellRenderer(new PortConfigErrorAwareRenderer(SoundPortTableModel.COLUMN_LABEL));
    // tc.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_LABEL));
    //
    // tc = table.getColumnModel().getColumn(SoundPortTableModel.COLUMN_PULSE_TIME);
    // tc.setCellRenderer(new SoundPortTableCellRenderer(SoundPortTableModel.COLUMN_PULSE_TIME));
    // tc.setCellEditor(new PortIntegerEditor(0, 255, SoundPortTableModel.COLUMN_PULSE_TIME));
    // tc.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_PULSE_TIME));
    //
    // tc = table.getColumnModel().getColumn(SoundPortTableModel.COLUMN_PORT_IDENTIFIER);
    // tc.setCellRenderer(new PortIdentifierTableCellRenderer());
    // tc.setMaxWidth(80);
    // tc.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_PORT_IDENTIFIER));
    //
    // // Set the status renderer
    // tc = table.getColumnModel().getColumn(SoundPortTableModel.COLUMN_STATUS);
    // tc.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_STATUS));
    // tc
    // .setCellRenderer(new BidibStatusTableRenderer(SoundPortStatus.class, "status.",
    // SoundPortTableModel.COLUMN_PORT_INSTANCE) {
    // private static final long serialVersionUID = 1L;
    //
    // @Override
    // protected boolean isPortEnabled(ConfigurablePort<?> port) {
    // if (port instanceof Port) {
    // if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SOUNDPORT) {
    // return false;
    // }
    // }
    // return true;
    // }
    // });
    // tc.setMaxWidth(80);
    //
    // final TableColumn buttonColumn = table.getColumnModel().getColumn(SoundPortTableModel.COLUMN_TEST);
    // buttonColumn.setIdentifier(Integer.valueOf(SoundPortTableModel.COLUMN_TEST));

    // buttonColumn
    // .setCellRenderer(new PortComboBoxWithButtonRenderer<BidibStatus>(table.getActions(SoundPortStatus.PLAY),
    // ">", SoundPortStatus.class, SoundPortTableModel.COLUMN_PORT_INSTANCE) {
    // private static final long serialVersionUID = 1L;
    //
    // @Override
    // protected void setSelectedValue(Port<?> port) {
    // SoundPortStatus currentStatus = null;
    // if (port != null) {
    // currentStatus = (SoundPortStatus) port.getStatus();
    // }
    // comboBox.setSelectedItem(currentStatus);
    // }
    //
    // @Override
    // protected boolean isPortEnabled(ConfigurablePort<?> port) {
    // if (port instanceof Port) {
    // if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SOUNDPORT) {
    // return false;
    // }
    // }
    // return true;
    // }
    // });

    // final PortComboBoxWithButtonEditorRenderer<BidibStatus> editor =
    // new PortComboBoxWithButtonEditorRenderer<BidibStatus>(table.getActions(SoundPortStatus.PLAY), ">",
    // SoundPortStatus.class, SoundPortTableModel.COLUMN_PORT_INSTANCE) {
    // private static final long serialVersionUID = 1L;
    //
    // @Override
    // protected boolean isPortEnabled(ConfigurablePort<?> port) {
    // if (port instanceof Port) {
    // if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SOUNDPORT) {
    // return false;
    // }
    // }
    // return true;
    // }
    // };
    // editor.addButtonListener(new ButtonListener() {
    //
    // @Override
    // public void buttonPressed(int row, int column, Object value) {
    // LOGGER.info("The test button was pressed, row: {}, column: {}", row, column);
    // // SoundPort soundPort = (SoundPort) table.getModel().getValueAt(row,
    // // tableModel.getColumnPortInstance());
    // // portListener.testButtonPressed(mainModel.getSelectedNode(), soundPort, soundPort.getStatus());
    // tableModel.setValueAt(value, row, SoundPortTableModel.COLUMN_TEST);
    // }
    // });
    // buttonColumn.setCellEditor(editor);
    // buttonColumn.setCellRenderer(editor);
    //
    // TableColumnChooser.hideColumn(table, SoundPortTableModel.COLUMN_PORT_INSTANCE);
    // }

    // @Override
    // protected PortTable createPortTable(
    // final SimplePortTableModel<SoundPortStatus, SoundPort, SoundPortModelListener> tableModel,
    // String emptyTableText) {
    //
    // PortTable portTable = new PortTable(tableModel, emptyTableText) {
    // private static final long serialVersionUID = 1L;
    //
    // @Override
    // public void clearTable() {
    // }
    //
    // @Override
    // protected PortListMenuListener createMenuListener() {
    // // create the port list menu
    // return new DefaultPortListMenuListener() {
    // @Override
    // public void editLabel(final MouseEvent popupEvent) {
    // final int row = getRow(popupEvent.getPoint());
    // if (row > -1) {
    // Object val = getValueAt(row, 0);
    // if (val instanceof Port<?>) {
    // val = ((Port<?>) val).toString();
    // }
    // final Object value = val;
    // if (value instanceof String) {
    // // show the port name editor
    // new LabelDialog((String) value, popupEvent.getXOnScreen(), popupEvent.getYOnScreen()) {
    // @Override
    // public void labelChanged(String label) {
    // setValueAt(label, row, 0);
    // }
    // };
    // }
    // }
    // else {
    // LOGGER.warn("The row is not available!");
    // }
    // }
    //
    // @Override
    // public void mapPort(final MouseEvent popupEvent, final LcOutputType lcOutputType) {
    //
    // final int row = getRow(popupEvent.getPoint());
    // if (row > -1) {
    // Object val = getValueAt(row, 0);
    // if (val instanceof SoundPort) {
    // SoundPort soundPort = (SoundPort) val;
    // LOGGER.info("Change mapping for port: {}", soundPort);
    //
    // // confirm switch to switch port
    // int result =
    // JOptionPane
    // .showConfirmDialog(JOptionPane.getFrameForComponent(SoundPortListPanel.this),
    // Resources.getString(SoundPortListPanel.class, "switch-port-confirm"),
    // Resources.getString(SoundPortListPanel.class, "switch-port-title"),
    // JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);
    // if (result == JOptionPane.OK_OPTION) {
    // LOGGER.info("Change the port to an sound port.");
    //
    // SoundPortTableModel switchPortTableModel = (SoundPortTableModel) getModel();
    // switchPortTableModel.changePortType(LcOutputType.SOUNDPORT, soundPort);
    // }
    // }
    // }
    // }
    // };
    // }
    //
    // };
    //
    // return portTable;
    // }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof SoundPortListPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected PackLastColumnEnum isPackLastColumn() {
        return PackLastColumnEnum.VARIABLE;
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();

        tabVisibilityListener.setTabVisible(this, isTabVisible());
    }

    @Override
    public Class<?> getPortClass() {
        return SoundPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasSoundPorts();
            LOGGER.debug("Check if tab is visible: {}", isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<SoundPort> getPorts() {
        NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            List<SoundPort> ports = new ArrayList<>();
            ports.addAll(node.getSoundPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        listChanged();
    }
}
