package org.bidib.wizard.mvc.preferences.view.panel;

import java.awt.BorderLayout;
import java.util.function.Consumer;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.Misc2SettingsInterface;
import org.bidib.wizard.core.model.settings.Misc2Settings;

import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class Misc2SettingsPanel extends AbstractSettingsPanel<Misc2SettingsInterface> {

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";

    private static final String ENCODED_DIALOG_ROW_SPECS =
        "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu";

    private final Misc2SettingsInterface misc2Settings;

    private JPanel contentPanel;

    public Misc2SettingsPanel(final Misc2SettingsInterface misc2Settings, final Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.misc2Settings = misc2Settings;
    }

    public JPanel createPanel() {

        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            JPanel panel = new FormDebugPanel();
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        else {
            JPanel panel = new JPanel(new BorderLayout());
            dialogBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(panel);
        }
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        // use value model here and only update settings on focus lost
        preparePresentationModel(this.misc2Settings);

        dialogBuilder.addSeparator(Resources.getString(getClass(), "nodeScriptWizard")).xyw(1, 1, 5);

        // hide welcome page in node script wizard
        final BufferedValueModel hideWelcomePageModel =
            presentationModel.getBufferedModel(Misc2Settings.PROPERTY_NODESCRIPTWIZARD_HIDEWELCOMEPAGE);

        JCheckBox hideWelcomePage =
            WizardComponentFactory
                .createCheckBox(hideWelcomePageModel, Resources.getString(getClass(), "hideWelcomePage"));

        dialogBuilder.add(hideWelcomePage).xyw(1, 3, 5);

        // preselect the last selected category in node script wizard
        final BufferedValueModel selectLastCategoryModel =
            presentationModel.getBufferedModel(Misc2Settings.PROPERTY_NODESCRIPTWIZARD_SELECTLASTCATEGORY);

        JCheckBox selectLastCategory =
            WizardComponentFactory
                .createCheckBox(selectLastCategoryModel, Resources.getString(getClass(), "selectLastCategory"));

        dialogBuilder.add(selectLastCategory).xyw(1, 5, 5);

        // build the panel
        contentPanel = dialogBuilder.build();
        contentPanel.setOpaque(false);
        return contentPanel;
    }
}
