package org.bidib.wizard.mvc.worklist.controller.actions;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

import javax.swing.JOptionPane;

import org.bidib.wizard.api.event.WizardUpdateWorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.worklist.controller.ActionAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vlsolutions.swing.docking.DockingDesktop;

public class DownloadWizardAction implements WorkListAction<WizardUpdateWorkListItemEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadWizardAction.class);

    public DownloadWizardAction() {
    }

    @Override
    public void apply(DockingDesktop desktop, WizardUpdateWorkListItemEvent actionEvent) throws ActionAbortedException {

        LOGGER.info("Let the wizard update service download the new installer.");
        String downloadUrl = actionEvent.getDownloadUrl();

        int result =
            JOptionPane
                .showConfirmDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()),
                    Resources.getString(DownloadWizardAction.class, "download-new-installer.text", downloadUrl),
                    Resources.getString(DownloadWizardAction.class, "download-new-installer.title"),
                    JOptionPane.YES_OPTION | JOptionPane.CANCEL_OPTION);

        if (result == JOptionPane.YES_OPTION) {
            LOGGER.info("Download the new installer to the local directory: {}", downloadUrl);

            try {
                Desktop.getDesktop().browse(URI.create(downloadUrl));
            }
            catch (IOException ex) {
                LOGGER.warn("Download the new installer to the local directory failed.", ex);
                throw new ActionAbortedException("Download the new installer to the local directory failed.");
            }
        }
        else {
            LOGGER.info("Download the new installer to the local directory was cancelled.");
            throw new ActionAbortedException("Download the new installer to the local directory was cancelled.");
        }
    }

}
