/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view.speedo;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.InfiniteProgressPanel;
import com.jidesoft.swing.OverlayTextArea;
import eu.hansolo.steelseries.extras.Led;
import eu.hansolo.steelseries.tools.LedColor;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.LabeledTextField;
import org.bidib.wizard.client.common.text.TrailingLabeledTextField;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.model.loco.listener.LocoModelListener;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.common.view.converter.CalculatingConverter;
import org.bidib.wizard.mvc.common.view.graph.LedBarGraph;
import org.bidib.wizard.mvc.loco.model.SpeedometerModel;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.bidib.wizard.mvc.loco.model.command.PomRequestProcessor;
import org.bidib.wizard.mvc.loco.model.command.SpeedometerPomCommand;
import org.bidib.wizard.mvc.loco.view.EmptyAddressHandler;
import org.bidib.wizard.mvc.loco.view.PomProgrammerRequestListener;
import org.bidib.wizard.mvc.loco.view.command.PomProgResultListener;
import org.bidib.wizard.mvc.loco.view.listener.LogPaneProvider;
import org.bidib.wizard.mvc.loco.view.listener.MeasurementViewListener;
import org.bidib.wizard.mvc.loco.view.listener.ProgressStatusCallback;
import org.bidib.wizard.mvc.loco.view.speedo.ApprovePidParamsDialog;
import org.bidib.wizard.mvc.loco.view.speedo.ApproveScaleDialog;
import org.bidib.wizard.mvc.loco.view.speedo.ApproveSpeedRangeDialog;
import org.bidib.wizard.mvc.loco.view.speedo.CallbackAction;
import org.bidib.wizard.mvc.loco.view.speedo.CvParamsBeanModel;
import org.bidib.wizard.mvc.loco.view.speedo.MeasurementProgressDialog;
import org.bidib.wizard.mvc.loco.view.speedo.PidParamsBeanModel;
import org.bidib.wizard.mvc.loco.view.speedo.SpeedScaleBeanModel;
import org.bidib.wizard.mvc.loco.view.speedo.SpeedometerPanel;
import org.bidib.wizard.mvc.loco.view.speedo.SpeedometerProgProxyBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.view.panel.AbstractPomPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomProgStateConverter;
import org.bidib.wizard.mvc.pom.view.panel.PomResultProxyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class SpeedometerPanel<M extends ProgCommandAwareBeanModel>
implements ViewCloseListener,
LogPaneProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpeedometerPanel.class);
    private static final Logger LOGGER_MEASUREMENT = LoggerFactory.getLogger((String)"MEASUREMENT");
    public static final int DEFAULT_TIMEOUT = 1000;
    private static final String NEWLINE = "\n";
    private final JPanel contentPanel;
    private ValueModel speedoFunctionsEnabled;
    private final JButton readCvButton;
    private final JButton writeCvButton;
    private JButton stopButton;
    private final JTextArea loggerArea;
    private final SpeedometerModel speedometerModel;
    private final LocoModel locoModel;
    private ValueModel addressValueModel;
    private JTextField address;
    private JComboBox<SpeedSteps> speedStepsCombo;
    private JTextField firmware;
    private final SpeedometerProgProxyBeanModel speedometerProgProxyBeanModel;
    private final SpeedometerProgBeanModel speedometerProgBeanModel;
    private final PresentationModel<SpeedometerProgBeanModel> speedometerPresentationModel;
    protected ValueModel currentOperationModel;
    protected JLabel currentOperationLabel;
    protected final PomProgrammerModel cvProgrammerModel;
    protected final PomResultProxyModel pomResultProxyModel;
    private ImageIcon progOperationErrorIcon;
    private ImageIcon progOperationSuccessfulIcon;
    private ImageIcon progOperationWaitIcon;
    private ImageIcon progOperationUnknownIcon;
    private ImageIcon progOperationEmptyIcon;
    private final InfiniteProgressPanel progressPanel;
    private final PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor;
    private boolean manualMeasurement = true;
    private final Led measurementLed;
    private TrailingLabeledTextField vSpeedStep1;
    private TrailingLabeledTextField vMiddle;
    private Trigger trigger;
    private JPanel locoAddressPanel;
    private ValidationResultModel validationModel;
    private LabeledTextField scale;
    private JToggleButton measureButton;
    private PropertyValidationI18NSupport validationSupport;
    private LedBarGraph ledBarGraph;
    private final Holder<MeasurementProgressDialog> measurementProgressDialogHolder = new Holder(this);
    private final SpeedometerProgBeanModel backupSpeedometerProgBeanModel;
    private SpeedScaleBeanModel speedScaleBeanModelSaved;
    private AtomicBoolean continueMeasurementHolder;
    private ProgressStatusCallback measurementProgressCallback;
    protected final ScheduledExecutorService measurementWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("measurementWorkers-thread-%d").build());
    private final BiFunction<Integer, Integer, Integer> speedConverterToKmH = (val, scaleVal) -> {
        int speedVal = 0;
        if (scaleVal != null && scaleVal > 1) {
            speedVal = (int)((double)val.intValue() * (double)scaleVal.intValue() / 277.778);
            LOGGER.info("Converted speed: {} to speedVal: {}, scaleVal: {}", new Object[]{val, speedVal, scaleVal});
        } else {
            speedVal = val;
        }
        return speedVal;
    };

    public SpeedometerPanel(SpeedometerModel speedometerModel, LocoModel locoModel, PomProgrammerRequestListener pomProgrammerRequestListener, SettingsService settingsService) {
        2 panel;
        this.speedometerModel = speedometerModel;
        this.locoModel = locoModel;
        this.speedoFunctionsEnabled = new ValueHolder(false);
        this.initializeIcons();
        this.validationModel = new DefaultValidationResultModel();
        this.cvProgrammerModel = new PomProgrammerModel();
        this.speedometerModel.setPomProgrammerModel(this.cvProgrammerModel);
        this.pomResultProxyModel = new PomResultProxyModel();
        this.pomResultProxyModel.setAllowUpdate(true);
        this.speedometerProgBeanModel = new SpeedometerProgBeanModel();
        this.speedometerProgProxyBeanModel = new SpeedometerProgProxyBeanModel(this.speedometerProgBeanModel);
        this.backupSpeedometerProgBeanModel = new SpeedometerProgBeanModel();
        this.trigger = new Trigger();
        this.speedometerPresentationModel = new PresentationModel((Object)this.speedometerProgBeanModel, (ValueModel)this.trigger);
        this.validationSupport = new PropertyValidationI18NSupport((Object)this.speedometerProgBeanModel, "validation");
        1 pomProgResultListener = new /* Unavailable Anonymous Inner Class!! */;
        this.pomRequestProcessor = new PomRequestProcessor((SpeedometerProgBeanModel)this.speedometerProgProxyBeanModel, locoModel, this.cvProgrammerModel, pomProgrammerRequestListener, (PomProgResultListener)pomProgResultListener, settingsService);
        this.speedometerModel.setPomRequestProcessor(this.pomRequestProcessor);
        this.pomRequestProcessor.addPomProgrammerModelListeners();
        LOGGER.info("Prepare the speedometer panel.");
        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            formBuilder = FormBuilder.create().columns("pref, 3dlu, pref:grow", new Object[0]).rows("pref, 5dlu, fill:100dlu:grow", new Object[0]).panel((JPanel)panel);
        } else {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            formBuilder = FormBuilder.create().columns("pref, 3dlu, pref:grow", new Object[0]).rows("pref, 5dlu, fill:100dlu:grow", new Object[0]).panel((JPanel)panel);
        }
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.measurementLed = new Led();
        this.measurementLed.setLedColor(LedColor.ORANGE_LED);
        this.measurementLed.setSize(24, 24);
        this.readCvButton = new JButton(Resources.getString(this.getClass(), (String)"readCv"));
        this.readCvButton.setEnabled(false);
        this.readCvButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeCvButton = new JButton(Resources.getString(this.getClass(), (String)"writeCv"));
        this.writeCvButton.setEnabled(false);
        this.writeCvButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.stopButton = new JButton(Resources.getString(this.getClass(), (String)"stop"));
        this.stopButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.locoAddressPanel = this.createLocoAddressPanel();
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)locoModel, "validation");
        this.validationModel.setResult(support.getResult());
        ImageIcon dirtyIcon = ImageUtils.createImageIcon(SpeedometerPanel.class, (String)"/icons/bullet_wrench.png", (int)12, (int)12);
        IconFeedbackPanel iconPanel = new IconFeedbackPanel(this.validationModel, (JComponent)this.locoAddressPanel, (Icon)dirtyIcon);
        formBuilder.add((Component)iconPanel).xyw(1, 1, 3);
        FormBuilder formBuilderProgResult = null;
        boolean debugDialogProgResult = false;
        formBuilderProgResult = debugDialogProgResult ? FormBuilder.create().columns("pref, 3dlu, pref:grow", new Object[0]).rows("pref, 5dlu, fill:100dlu:grow", new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns("pref, 3dlu, pref:grow", new Object[0]).rows("pref, 5dlu, fill:100dlu:grow", new Object[0]);
        this.currentOperationModel = new PropertyAdapter((Object)this.pomResultProxyModel, "pomProgState", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.currentOperationModel, (BindingConverter)new PomProgStateConverter());
        this.currentOperationLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        this.currentOperationLabel.setIcon(this.progOperationEmptyIcon);
        formBuilderProgResult.add(Resources.getString(AbstractPomPanel.class, (String)"prog-result"), new Object[0]).xy(1, 1);
        formBuilderProgResult.add((Component)this.currentOperationLabel).xy(3, 1);
        this.loggerArea = new OverlayTextArea();
        this.loggerArea.setColumns(40);
        this.loggerArea.setRows(20);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        JScrollPane scrollPane = new JScrollPane(20, 30);
        scrollPane.getViewport().add(this.loggerArea);
        this.loggerArea.setEditable(false);
        scrollPane.setOpaque(FormsSetup.getOpaqueDefault());
        scrollPane.getViewport().setOpaque(FormsSetup.getOpaqueDefault());
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        JMenuItem clearConsole = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_console"));
        clearConsole.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(clearConsole);
        this.loggerArea.setComponentPopupMenu((JPopupMenu)popupMenu);
        DefaultOverlayable overlayTextArea = new DefaultOverlayable((JComponent)scrollPane);
        this.progressPanel = new /* Unavailable Anonymous Inner Class!! */;
        overlayTextArea.addOverlayComponent((JComponent)this.progressPanel);
        this.progressPanel.stop();
        overlayTextArea.setOverlayVisible(false);
        formBuilderProgResult.add((Component)overlayTextArea).xyw(1, 3, 3);
        JPanel progResultPanel = formBuilderProgResult.build();
        formBuilder.add((Component)progResultPanel).xyw(1, 3, 3);
        this.contentPanel = formBuilder.build();
        speedometerModel.addPropertyChangeListener("speedMeasurementStage", evt -> {
            LOGGER.info("The speedmeasurement stage has changed: {}", (Object)speedometerModel.getSpeedMeasurementStage());
            switch (30.$SwitchMap$org$bidib$wizard$mvc$loco$model$SpeedometerModel$SpeedMeasurementStage[speedometerModel.getSpeedMeasurementStage().ordinal()]) {
                case 1: {
                    this.addLogText("Wait for speed and battery status from car with address: {}", new Object[]{locoModel.getAddress()});
                    break;
                }
                case 2: {
                    this.addLogText("Read the current Vmin and Scale values from car with address: {}", new Object[]{locoModel.getAddress()});
                    break;
                }
                case 3: {
                    this.addLogText("Current measurement was aborted.", new Object[0]);
                    break;
                }
                case 4: {
                    this.addLogText("Current measurement has finished.", new Object[0]);
                    break;
                }
                default: {
                    this.addLogText("Received update of speedmeasurement stage: {}", new Object[]{speedometerModel.getSpeedMeasurementStage()});
                }
            }
        });
        speedometerModel.addPropertyChangeListener("dynStateEnergy", evt -> LOGGER.info("The DYN_STATE has changed: {}", (Object)speedometerModel.getDynStateEnergy()));
        speedometerModel.addPropertyChangeListener("speed", evt -> LOGGER.info("The SPEED has changed: {}", (Object)speedometerModel.getSpeed()));
        this.addPomProgrammerModelListeners();
        this.doBindButtons();
        LOGGER.info("Finished prepare the speedometer panel.");
    }

    private void addPomProgrammerModelListeners() {
        this.cvProgrammerModel.addPropertyChangeListener("pomProgState", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initializeIcons() {
        this.progOperationErrorIcon = ImageUtils.createImageIcon(SpeedometerPanel.class, (String)"/icons/accessory-error.png");
        this.progOperationSuccessfulIcon = ImageUtils.createImageIcon(SpeedometerPanel.class, (String)"/icons/accessory-successful.png");
        this.progOperationWaitIcon = ImageUtils.createImageIcon(SpeedometerPanel.class, (String)"/icons/accessory-wait.png");
        this.progOperationUnknownIcon = ImageUtils.createImageIcon(SpeedometerPanel.class, (String)"/icons/information.png");
        this.progOperationEmptyIcon = ImageUtils.createImageIcon(SpeedometerPanel.class, (String)"/icons/empty.png");
    }

    protected void doBindButtons() {
        EmptyAddressHandler handler = new EmptyAddressHandler(value -> {
            LOGGER.info("The address value is not empty: {}", value);
            this.speedoFunctionsEnabled.setValue(value);
        });
        PropertyConnector.connect((Object)this.locoModel, (String)"address", (Object)handler, (String)"address").updateProperty2();
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)this.readCvButton, (String)"enabled");
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)this.writeCvButton, (String)"enabled");
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private void fireClearConsole() {
        LOGGER.info("clear the console.");
        this.loggerArea.setText(null);
    }

    private JPanel createLocoAddressPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 50dlu, 10dlu, pref, 3dlu, 50dlu, 10dlu, pref, 3dlu, 50dlu, 10dlu, pref, 3dlu, 50dlu, 10dlu, pref, pref:grow", new Object[0]).rows("pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref", new Object[0]);
        formBuilder.add((Component)this.readCvButton).xyw(1, 1, 3);
        formBuilder.add((Component)this.writeCvButton).xyw(5, 1, 3);
        formBuilder.add((Component)this.stopButton).xyw(11, 1, 3);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"vehicle"), new Object[0]).xyw(1, 3, 18);
        this.addressValueModel = new PropertyAdapter((Object)this.locoModel, "address", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.address = WizardComponentFactory.createTextField((ValueModel)addressConverterModel, (boolean)false);
        this.address.setDocument((Document)new InputValidationDocument("0123456789"));
        if (this.locoModel.getAddress() != null) {
            this.address.setText(Integer.toString(this.locoModel.getAddress()));
        } else {
            this.address.setText(null);
        }
        this.address.getDocument().addDocumentListener((DocumentListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(1, 5);
        formBuilder.add((Component)this.address).xy(3, 5);
        boolean m4SupportEnabled = false;
        if (m4SupportEnabled) {
            this.speedStepsCombo = new JComboBox<SpeedSteps>(SpeedSteps.values());
        } else {
            ArrayList<SpeedSteps> speedSteps = new ArrayList<SpeedSteps>();
            speedSteps.addAll(Arrays.asList(SpeedSteps.values()));
            CollectionUtils.filter(speedSteps, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            this.speedStepsCombo = new JComboBox<SpeedSteps>(speedSteps.toArray(new SpeedSteps[0]));
        }
        this.speedStepsCombo.setSelectedItem(this.locoModel.getSpeedSteps());
        this.speedStepsCombo.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add(Resources.getString(this.getClass(), (String)"speedSteps"), new Object[0]).xy(5, 5);
        formBuilder.add((Component)this.speedStepsCombo).xy(7, 5);
        BufferedValueModel firmwareValueModel = this.speedometerPresentationModel.getBufferedModel("firmware");
        this.firmware = WizardComponentFactory.createTextField((ValueModel)firmwareValueModel, (boolean)false);
        this.firmware.setEditable(false);
        formBuilder.add(Resources.getString(this.getClass(), (String)"firmware"), new Object[0]).xy(9, 5);
        formBuilder.add((Component)this.firmware).xy(11, 5);
        this.ledBarGraph = new LedBarGraph(10, LedBarGraph.Orientation.horizontal);
        this.ledBarGraph.setOpaque(FormsSetup.getOpaqueDefault());
        formBuilder.add((Component)this.ledBarGraph).xyw(13, 5, 3);
        13 locoModelListener = new /* Unavailable Anonymous Inner Class!! */;
        this.locoModel.addLocoModelListener((LocoModelListener)locoModelListener);
        ValidationComponentUtils.setMandatory((JComponent)this.firmware, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.firmware, (Object)"validation.firmware_key");
        this.prepareFirmwareValidationListener((JComponent)this.firmware, firmwareValueModel, this.speedometerProgBeanModel, "firmware_key");
        BufferedValueModel vMinValueModel = this.speedometerPresentationModel.getBufferedModel("cv2Vmin");
        ConverterValueModel vMinConverterModel = new ConverterValueModel((ValueModel)vMinValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv2Document = new InputValidationDocument(3, "0123456789");
        cv2Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        TrailingLabeledTextField vMin = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)vMinConverterModel, (boolean)false, (String)"PWM%", (Document)cv2Document);
        vMin.getTextField().setEditable(this.manualMeasurement);
        vMin.setHintText("CV2");
        vMin.setToolTipText(Resources.getString(this.getClass(), (String)"vMinPref.tooltip"));
        JLabel vMinPrefLabel = new JLabel(Resources.getString(this.getClass(), (String)"vMinPref"));
        vMinPrefLabel.setToolTipText(Resources.getString(this.getClass(), (String)"vMinPref.tooltip"));
        formBuilder.add((Component)vMinPrefLabel).xy(1, 7);
        formBuilder.add((Component)vMin).xy(3, 7);
        ValidationComponentUtils.setMandatory((JComponent)vMin, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)vMin, (Object)"validation.cv2_key");
        this.prepareDirtyListener((JComponent)vMin, vMinValueModel, this.speedometerProgBeanModel, "cv2Vmin", "cv2_key");
        BufferedValueModel vMaxValueModel = this.speedometerPresentationModel.getBufferedModel("cv5Vmax");
        ConverterValueModel vMaxConverterModel = new ConverterValueModel((ValueModel)vMaxValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv5Document = new InputValidationDocument(3, "0123456789");
        cv5Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        TrailingLabeledTextField vMax = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)vMaxConverterModel, (boolean)false, (String)"PWM%", (Document)cv5Document);
        vMax.getTextField().setEditable(this.manualMeasurement);
        vMax.setHintText("CV5");
        vMax.setToolTipText(Resources.getString(this.getClass(), (String)"vMax.tooltip"));
        JLabel vMaxLabel = new JLabel(Resources.getString(this.getClass(), (String)"vMax"));
        vMaxLabel.setToolTipText(Resources.getString(this.getClass(), (String)"vMax.tooltip"));
        formBuilder.add((Component)vMaxLabel).xy(5, 7);
        formBuilder.add((Component)vMax).xy(7, 7);
        ValidationComponentUtils.setMandatory((JComponent)vMax, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)vMax, (Object)"validation.cv5_key");
        this.prepareDirtyListener((JComponent)vMax, vMaxValueModel, this.speedometerProgBeanModel, "cv5Vmax", "cv5_key");
        JButton autoAdjustButton = new JButton(Resources.getString(this.getClass(), (String)"autoAdjust"));
        autoAdjustButton.setToolTipText(Resources.getString(this.getClass(), (String)"autoAdjust.tooltip"));
        autoAdjustButton.setEnabled(false);
        autoAdjustButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)autoAdjustButton).xyw(11, 7, 3);
        formBuilder.addSeparator("Speedometer", new Object[0]).xyw(1, 9, 18);
        this.measureButton = new JToggleButton(Resources.getString(this.getClass(), (String)"measurement"));
        this.measureButton.setEnabled(false);
        this.measureButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.measureButton.setEnabled(false);
        PropertyAdapter speedValueModel = new PropertyAdapter((Object)this.speedometerModel, "reportedSpeed", true);
        ConverterValueModel speedConverterModel = new ConverterValueModel((ValueModel)speedValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        TrailingLabeledTextField speedValue = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)speedConverterModel, (boolean)false, (String)"mm/s", null);
        speedValue.getTextField().setEditable(false);
        speedValue.setHintText("Speed");
        formBuilder.add(Resources.getString(this.getClass(), (String)"speed"), new Object[0]).xy(1, 11);
        formBuilder.add((Component)speedValue).xy(3, 11);
        BufferedValueModel scaleValueModel = this.speedometerPresentationModel.getBufferedModel("cv37Scale");
        ConverterValueModel scaleConverterModel = new ConverterValueModel((ValueModel)scaleValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv37Document = new InputValidationDocument(3, "0123456789");
        cv37Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        this.scale = WizardComponentFactory.createLabeledTextField((ValueModel)scaleConverterModel, (boolean)false, (String)"1:", (Document)cv37Document);
        this.scale.getTextField().setEditable(this.manualMeasurement);
        this.scale.setHintText("CV37");
        formBuilder.add(Resources.getString(this.getClass(), (String)"scale"), new Object[0]).xy(5, 11);
        formBuilder.add((Component)this.scale).xy(7, 11);
        ValidationComponentUtils.setMandatory((JComponent)this.scale, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.scale, (Object)"validation.scale_key");
        this.prepareDirtyListener((JComponent)this.scale, scaleValueModel, this.speedometerProgBeanModel, "cv37Scale", "scale_key");
        this.speedometerProgBeanModel.addPropertyChangeListener("cv37Scale", evt -> {
            boolean scaleAvailable = this.speedometerProgBeanModel.getCv37Scale() != null;
            LOGGER.info("The scale property has changed: {}", (Object)scaleAvailable);
            this.measureButton.setEnabled(scaleAvailable | this.measureButton.isSelected() && Boolean.TRUE.equals(this.speedoFunctionsEnabled.getValue()));
        });
        PropertyAdapter speedKmHValueModel = new PropertyAdapter((Object)this.speedometerModel, "reportedSpeed", true);
        ConverterValueModel speedKmHConverterModel = new ConverterValueModel((ValueModel)speedKmHValueModel, (BindingConverter)new CalculatingConverter((Format)new DecimalFormat("#"), val -> {
            Integer scaleVal = this.speedometerProgBeanModel.getCv37Scale();
            int speedVal = 0;
            if (scaleVal != null && scaleVal > 1) {
                speedVal = (int)((double)val.intValue() * (double)scaleVal.intValue() / 277.778);
                LOGGER.info("Converted speed, {} mm/s --> {} km/h", val, (Object)speedVal);
            } else {
                speedVal = val;
            }
            return speedVal;
        }));
        TrailingLabeledTextField speedKmHValue = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)speedKmHConverterModel, (boolean)false, (String)"km/h", null);
        speedKmHValue.getTextField().setEditable(false);
        speedKmHValue.setHintText("Speed");
        formBuilder.add(Resources.getString(this.getClass(), (String)"speed"), new Object[0]).xy(9, 11);
        formBuilder.add((Component)speedKmHValue).xy(11, 11);
        formBuilder.add((Component)this.measureButton).xy(13, 11);
        formBuilder.add((Component)this.measurementLed).xy(15, 11);
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)this.measureButton, (String)"enabled");
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"velocity"), new Object[0]).xyw(1, 13, 18);
        BufferedValueModel vSpeedStep1ValueModel = this.speedometerPresentationModel.getBufferedModel("cv35");
        ConverterValueModel vSpeedStep1ConverterModel = new ConverterValueModel((ValueModel)vSpeedStep1ValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv35Document = new InputValidationDocument(3, "0123456789");
        cv35Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        this.vSpeedStep1 = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)vSpeedStep1ConverterModel, (boolean)false, (String)"mm/s", (Document)cv35Document);
        this.vSpeedStep1.getTextField().setEditable(this.manualMeasurement);
        this.vSpeedStep1.setHintText("CV35");
        JButton speedStep2Button = new JButton(Resources.getString(this.getClass(), (String)"speedStep2"));
        speedStep2Button.setEnabled(false);
        speedStep2Button.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton speedToCv35Button = new JButton(Resources.getString(this.getClass(), (String)"speedToCv35"));
        speedToCv35Button.setToolTipText(Resources.getString(this.getClass(), (String)"speedToCv35.tooltip"));
        speedToCv35Button.setEnabled(false);
        speedToCv35Button.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)speedStep2Button).xyw(1, 15, 3);
        formBuilder.add((Component)speedToCv35Button).xyw(5, 15, 3);
        formBuilder.add(Resources.getString(this.getClass(), (String)"vMin"), new Object[0]).xy(9, 15);
        formBuilder.add((Component)this.vSpeedStep1).xy(11, 15);
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)speedStep2Button, (String)"enabled");
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)speedToCv35Button, (String)"enabled");
        ValidationComponentUtils.setMandatory((JComponent)this.vSpeedStep1, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)this.vSpeedStep1, (Object)"validation.cv35_key");
        this.prepareDirtyListener((JComponent)this.vSpeedStep1, vSpeedStep1ValueModel, this.speedometerProgBeanModel, "cv35", "cv35_key");
        BufferedValueModel vMiddleValueModel = this.speedometerPresentationModel.getBufferedModel("cv36");
        ConverterValueModel vMiddleConverterModel = new ConverterValueModel((ValueModel)vMiddleValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv36Document = new InputValidationDocument(3, "0123456789");
        cv36Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        this.vMiddle = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)vMiddleConverterModel, (boolean)false, (String)"mm/s", (Document)cv36Document);
        this.vMiddle.getTextField().setEditable(this.manualMeasurement);
        this.vMiddle.setHintText("CV36");
        JButton speedStep64Button = new JButton(Resources.getString(this.getClass(), (String)"speedStep64"));
        speedStep64Button.setEnabled(false);
        speedStep64Button.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton speedToCv36Button = new JButton(Resources.getString(this.getClass(), (String)"speedToCv36"));
        speedToCv36Button.setEnabled(false);
        speedToCv36Button.setToolTipText(Resources.getString(this.getClass(), (String)"speedToCv36.tooltip"));
        speedToCv36Button.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)speedStep64Button).xyw(1, 17, 3);
        formBuilder.add((Component)speedToCv36Button).xyw(5, 17, 3);
        formBuilder.add(Resources.getString(this.getClass(), (String)"vMid"), new Object[0]).xy(9, 17);
        formBuilder.add((Component)this.vMiddle).xy(11, 17);
        ValidationComponentUtils.setMessageKey((JComponent)this.vMiddle, (Object)"validation.cv36_key");
        this.prepareDirtyListener((JComponent)this.vMiddle, vMiddleValueModel, this.speedometerProgBeanModel, "cv36", "cv36_key");
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)speedStep64Button, (String)"enabled");
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)speedToCv36Button, (String)"enabled");
        PropertyConnector.connect((Object)this.speedoFunctionsEnabled, (String)"value", (Object)autoAdjustButton, (String)"enabled");
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"pid"), new Object[0]).xyw(1, 19, 18);
        BufferedValueModel pValueModel = this.speedometerPresentationModel.getBufferedModel("cv61");
        ConverterValueModel pConverterModel = new ConverterValueModel((ValueModel)pValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv61Document = new InputValidationDocument(3, "0123456789");
        cv61Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        TrailingLabeledTextField pValue = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)pConverterModel, (boolean)false, (String)"   ", (Document)cv61Document);
        pValue.getTextField().setEditable(this.manualMeasurement);
        pValue.setHintText("CV61");
        formBuilder.add(Resources.getString(this.getClass(), (String)"pValue"), new Object[0]).xy(1, 21);
        formBuilder.add((Component)pValue).xy(3, 21);
        ValidationComponentUtils.setMandatory((JComponent)pValue, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)pValue, (Object)"validation.cv61_key");
        this.prepareDirtyListener((JComponent)pValue, pValueModel, this.speedometerProgBeanModel, "cv61", "cv61_key");
        BufferedValueModel iValueModel = this.speedometerPresentationModel.getBufferedModel("cv62");
        ConverterValueModel iConverterModel = new ConverterValueModel((ValueModel)iValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv62Document = new InputValidationDocument(3, "0123456789");
        cv62Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        TrailingLabeledTextField iValue = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)iConverterModel, (boolean)false, (String)"   ", (Document)cv62Document);
        iValue.getTextField().setEditable(this.manualMeasurement);
        iValue.setHintText("CV62");
        formBuilder.add(Resources.getString(this.getClass(), (String)"iValue"), new Object[0]).xy(5, 21);
        formBuilder.add((Component)iValue).xy(7, 21);
        ValidationComponentUtils.setMandatory((JComponent)iValue, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)iValue, (Object)"validation.cv62_key");
        this.prepareDirtyListener((JComponent)iValue, iValueModel, this.speedometerProgBeanModel, "cv62", "cv62_key");
        BufferedValueModel dValueModel = this.speedometerPresentationModel.getBufferedModel("cv63");
        ConverterValueModel dConverterModel = new ConverterValueModel((ValueModel)dValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        InputValidationDocument cv63Document = new InputValidationDocument(3, "0123456789");
        cv63Document.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, 255));
        TrailingLabeledTextField dValue = WizardComponentFactory.createTrailingLabeledTextField((ValueModel)dConverterModel, (boolean)false, (String)"   ", (Document)cv63Document);
        dValue.getTextField().setEditable(this.manualMeasurement);
        dValue.setHintText("CV63");
        formBuilder.add(Resources.getString(this.getClass(), (String)"dValue"), new Object[0]).xy(9, 21);
        formBuilder.add((Component)dValue).xy(11, 21);
        ValidationComponentUtils.setMandatory((JComponent)dValue, (boolean)true);
        ValidationComponentUtils.setMessageKey((JComponent)dValue, (Object)"validation.cv63_key");
        this.prepareDirtyListener((JComponent)dValue, dValueModel, this.speedometerProgBeanModel, "cv63", "cv63_key");
        return formBuilder.build();
    }

    public void validate() {
        LOGGER.trace("Validate the values.");
        ValidationResult validationResult = this.validationSupport.getResult();
        this.validationModel.setResult(validationResult);
    }

    private void prepareDirtyListener(JComponent textField, BufferedValueModel valueModel, SpeedometerProgBeanModel speedometerProgBeanModel, String cvNumber, String validationKey) {
        try {
            Method getterMethod = SpeedometerProgBeanModel.class.getDeclaredMethod("get" + StringUtils.capitalize((String)cvNumber), new Class[0]);
            valueModel.addValueChangeListener(evt -> {
                LOGGER.trace("Value of {} in model has changed, new value: {}", (Object)cvNumber, evt.getNewValue());
                try {
                    if (Objects.equals(valueModel.getValue(), getterMethod.invoke((Object)speedometerProgBeanModel, new Object[0]))) {
                        this.validationSupport.remove(validationKey);
                    } else {
                        this.validationSupport.add(Severity.INFO, validationKey, "value_dirty");
                    }
                    this.validate();
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the overlay visible/invisible failed.", (Throwable)ex);
                }
            });
        }
        catch (NoSuchMethodException | SecurityException ex) {
            LOGGER.warn("Get the getter method failed: {}", (Object)cvNumber, (Object)ex);
            throw new RuntimeException("Get the getter method failed: " + cvNumber);
        }
        valueModel.addPropertyChangeListener("buffering", evt -> {
            if (Boolean.FALSE == evt.getNewValue()) {
                LOGGER.debug("{} is not buffering, hide overlay.", (Object)cvNumber);
                this.validationSupport.remove(validationKey);
                this.validate();
            }
        });
    }

    private void prepareFirmwareValidationListener(JComponent textField, BufferedValueModel valueModel, SpeedometerProgBeanModel speedometerProgBeanModel, String validationKey) {
        try {
            valueModel.addValueChangeListener(evt -> {
                LOGGER.debug("Value of firmware in model has changed, new value: {}", evt.getNewValue());
                LOGGER.debug("CV111: {}, CV59: {}", (Object)speedometerProgBeanModel.getCv111(), (Object)speedometerProgBeanModel.getCv59());
                if (speedometerProgBeanModel.getCv111() != null && speedometerProgBeanModel.getCv111() / 10 == 3) {
                    if (speedometerProgBeanModel.getCv59() != null && (speedometerProgBeanModel.getCv59() & 0x80) == 0) {
                        LOGGER.warn("No load control enabled.");
                        this.validationSupport.remove(validationKey);
                        this.validationSupport.add(Severity.WARNING, validationKey, "load_control_not_active");
                    }
                } else {
                    this.validationSupport.remove(validationKey);
                }
                this.validate();
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Check if load control is enabled failed: {}", (Throwable)ex);
        }
        valueModel.addPropertyChangeListener("buffering", evt -> {
            if (Boolean.FALSE == evt.getNewValue()) {
                LOGGER.info("Firmware is not buffering, hide overlay.");
                this.validationSupport.remove(validationKey);
                this.validate();
            }
        });
    }

    protected void fireSpeedToCv35() {
        Integer reportedSpeed = this.speedometerModel.getReportedSpeed();
        LOGGER.info("Set the speed step 2 speed: {}", (Object)reportedSpeed);
        this.vSpeedStep1.setText(reportedSpeed != null ? reportedSpeed.toString() : null);
    }

    protected void fireSpeedToCv36() {
        Integer reportedSpeed = this.speedometerModel.getReportedSpeed();
        LOGGER.info("Set the speed step 64 speed: {}", (Object)reportedSpeed);
        this.vMiddle.setText(reportedSpeed != null ? reportedSpeed.toString() : null);
    }

    public void addLogText(String logMessage, Object ... args) {
        LOGGER.info(logMessage, args);
        if (args != null) {
            logMessage = MessageFormatter.arrayFormat((String)logMessage, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        StringBuilder message = new StringBuilder(sdf.format(new Date()));
        message.append(logMessage).append(NEWLINE);
        if (SwingUtilities.isEventDispatchThread()) {
            this.loggerArea.append(message.toString());
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void clearModelValues() {
        LOGGER.info("Clear the model values.");
        this.clearAllCvValues();
        this.fireClearConsole();
    }

    private void clearAllCvValues() {
        this.speedometerProgProxyBeanModel.setCv2Vmin(null);
        this.speedometerProgProxyBeanModel.setCv5Vmax(null);
        this.speedometerProgProxyBeanModel.setCv37Scale(null);
        this.speedometerProgProxyBeanModel.setCv35(null);
        this.speedometerProgProxyBeanModel.setCv36(null);
        this.speedometerProgProxyBeanModel.setCv59(null);
        this.speedometerProgProxyBeanModel.setCv111(null);
        this.speedometerProgProxyBeanModel.setCv61(null);
        this.speedometerProgProxyBeanModel.setCv62(null);
        this.speedometerProgProxyBeanModel.setCv63(null);
        this.speedometerProgProxyBeanModel.setCv7(null);
        this.speedometerProgProxyBeanModel.setCv109(null);
        this.speedometerProgProxyBeanModel.setCv110(null);
    }

    private void backupCurrentCvValues() {
        LOGGER.info("Backup the current CV values from the speedometer bean model.");
        try {
            BeanUtils.copyProperties((Object)this.backupSpeedometerProgBeanModel, (Object)this.speedometerProgBeanModel);
            LOGGER.info("Created a backup of the current cv values: {}", (Object)this.backupSpeedometerProgBeanModel);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOGGER.warn("Backup current cv values failed.", (Throwable)ex);
        }
    }

    private void fireReadCvValues(CallbackAction finishCallback) {
        LOGGER.info("Read the values from the decoder");
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.internalFireReadCvValues(finishCallback));
        } else {
            this.internalFireReadCvValues(finishCallback);
        }
    }

    private void internalFireReadCvValues(CallbackAction finishCallback) {
        LOGGER.info("internalFireReadCvValues");
        this.speedoFunctionsEnabled.setValue((Object)false);
        this.clearAllCvValues();
        21 completeAction = new /* Unavailable Anonymous Inner Class!! */;
        this.speedometerModel.setCompleteAction((SingleObserver)completeAction);
        LOGGER.info("Let the pomRequestProcessor load the related CV values.");
        this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.READ_CURRENT_CV_VALUES);
    }

    private boolean isMeasurementAborted() {
        return SpeedometerModel.SpeedMeasurementStage.ABORTED == this.speedometerModel.getSpeedMeasurementStage();
    }

    private void getFullSpeedRange() {
        LOGGER.info("Get the full speed range.");
        if (this.isMeasurementAborted()) {
            LOGGER.info("The measurement is aborted. Skip get full speed range.");
            return;
        }
        LOGGER.info("Set the speed measurement stage to STOP_FOR_USER_INTERACTION.");
        this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.STOP_FOR_USER_INTERACTION);
        this.speedoFunctionsEnabled.setValue((Object)true);
        if (this.speedScaleBeanModelSaved == null) {
            this.speedScaleBeanModelSaved = new SpeedScaleBeanModel();
        }
        this.speedScaleBeanModelSaved.setCv37Scale(this.speedometerProgBeanModel.getCv37Scale());
        int result = 2;
        ApproveScaleDialog dialog = new ApproveScaleDialog(JOptionPane.getFrameForComponent(this.contentPanel), this.speedScaleBeanModelSaved);
        result = dialog.getResult();
        LOGGER.info("Result: {}", (Object)result);
        switch (result) {
            case 0: {
                LOGGER.info("The approved scale value: {}", (Object)this.speedScaleBeanModelSaved.getCv37Scale());
                CvParamsBeanModel cvParamsBeanModel = new CvParamsBeanModel();
                if (this.speedScaleBeanModelSaved.getCv37Scale() != null && this.speedScaleBeanModelSaved.getCv37Scale() != this.speedometerProgBeanModel.getCv37Scale()) {
                    LOGGER.info("The scale value was changed. Write new scale to decoder: {}", (Object)this.speedScaleBeanModelSaved.getCv37Scale());
                    cvParamsBeanModel.setCv37(this.speedScaleBeanModelSaved.getCv37Scale());
                }
                this.speedometerModel.setCv37Scale(this.speedScaleBeanModelSaved.getCv37Scale());
                cvParamsBeanModel.setCv2(Integer.valueOf(1));
                cvParamsBeanModel.setCv5(Integer.valueOf(100));
                LOGGER.info("Write default CV 2 and CV 5 values.");
                this.writeCvValues((PidParamsBeanModel)cvParamsBeanModel, this.speedometerProgBeanModel, () -> {
                    LOGGER.info("The finish callback is called after change the scale CV");
                    this.updateProgressText("Detect full speed range.");
                    this.scheduleFullSpeedRangeDetection();
                }, () -> {
                    LOGGER.info("The error callback is called after change the scale CV");
                    this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.ABORTED);
                    this.fireMeasurementStop();
                });
                break;
            }
            default: {
                LOGGER.warn("User aborted the speed measurement operation in approve scale dialog.");
                this.fireMeasurementStop();
            }
        }
    }

    private void updateProgressText(String progressText) {
        LOGGER_MEASUREMENT.info(progressText);
        if (this.measurementProgressCallback != null) {
            try {
                this.measurementProgressCallback.textChanged("<html>" + progressText + "</html>");
            }
            catch (Exception ex) {
                LOGGER.warn("Signal new progress text to callback failed.", (Throwable)ex);
            }
        }
    }

    private void scheduleFullSpeedRangeDetection() {
        LOGGER.info("Schedule the worker for the full speed range detection.");
        int delay = 0;
        this.measurementWorker.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, (long)delay, TimeUnit.MILLISECONDS);
    }

    private boolean speedAdjustmentLoop(BiFunction<Integer, Integer, Integer> speedConverter, Integer scaleVal, int maxAdjustmentDuration, Consumer<Integer> speedValueConsumer, String logTextPrefix) {
        boolean speedValueReached = false;
        LocalDateTime maxAdjustmentTime = LocalDateTime.now().plusSeconds(maxAdjustmentDuration);
        int lastSpeedValue = 0;
        do {
            try {
                this.addLogText("Wait 2s before compare speed value.", new Object[0]);
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for a stable speed measurement value failed.", (Throwable)ex);
            }
            Integer currentSpeedValue = this.speedometerModel.getReportedSpeed();
            if (currentSpeedValue == null) {
                currentSpeedValue = 0;
            }
            Integer convertedSpeed = speedConverter.apply(currentSpeedValue, scaleVal);
            LOGGER.info("Current speed value: {}, convertedSpeed: {}", (Object)currentSpeedValue, (Object)convertedSpeed);
            this.updateProgressText(logTextPrefix + "<br>Current speed: " + convertedSpeed + " km/h");
            if (currentSpeedValue > lastSpeedValue) {
                lastSpeedValue = currentSpeedValue;
                this.addLogText("Changed speed value detected: {} mm/s ({} km/h). Wait for final speed.", new Object[]{lastSpeedValue, convertedSpeed});
                continue;
            }
            this.addLogText("Final speed detected: {} mm/s ({} km/h)", new Object[]{lastSpeedValue, convertedSpeed});
            speedValueReached = true;
            speedValueConsumer.accept(lastSpeedValue);
        } while (!speedValueReached && LocalDateTime.now().isBefore(maxAdjustmentTime));
        return speedValueReached;
    }

    private void validateVMinAndScaleValue() {
        LOGGER.info("Validate the speed range and scale values.");
        SpeedScaleBeanModel speedScaleBeanModelIn = new SpeedScaleBeanModel();
        speedScaleBeanModelIn.setCv37Scale(this.speedometerProgBeanModel.getCv37Scale());
        speedScaleBeanModelIn.setTargetMinSpeed(Integer.valueOf(6));
        speedScaleBeanModelIn.setTargetMaxSpeed(Integer.valueOf(80));
        if (this.speedScaleBeanModelSaved != null) {
            speedScaleBeanModelIn.setMeasuredMinSpeed(this.speedScaleBeanModelSaved.getMeasuredMinSpeed());
            speedScaleBeanModelIn.setMeasuredMaxSpeed(this.speedScaleBeanModelSaved.getMeasuredMaxSpeed());
            speedScaleBeanModelIn.setTargetMinSpeed(this.speedScaleBeanModelSaved.getTargetMinSpeed());
            speedScaleBeanModelIn.setTargetMaxSpeed(this.speedScaleBeanModelSaved.getTargetMaxSpeed());
        }
        int result = 2;
        ApproveSpeedRangeDialog dialog = null;
        if (!this.isMeasurementAborted()) {
            this.updateProgressText("Validate the speed values.");
            dialog = new ApproveSpeedRangeDialog(JOptionPane.getFrameForComponent(this.contentPanel), speedScaleBeanModelIn);
            result = dialog.getResult();
            LOGGER.info("Result: {}", (Object)result);
            if (this.isMeasurementAborted()) {
                result = 2;
            }
        }
        switch (result) {
            case 0: {
                ArrayList<SpeedometerPomCommand> pomProgCommands = new ArrayList<SpeedometerPomCommand>();
                PomAddressData addressData = new PomAddressData(this.locoModel.getAddress().intValue(), PomAddressTypeEnum.LOCOMOTIVE);
                SpeedScaleBeanModel speedScaleBeanModel = dialog.getSpeedScaleBeanModel();
                if (!Objects.equals(speedScaleBeanModel.getCv37Scale(), this.speedometerProgBeanModel.getCv37Scale())) {
                    int scale = speedScaleBeanModel.getCv37Scale();
                    LOGGER.info("scale value has changed: {}", (Object)scale);
                    pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 37, (int)ByteUtils.getLowByte((int)scale)));
                }
                23 completeAction = new /* Unavailable Anonymous Inner Class!! */;
                if (CollectionUtils.isNotEmpty(pomProgCommands)) {
                    LOGGER.info("Update the changed values.");
                    SwingUtilities.invokeLater(() -> this.lambda$validateVMinAndScaleValue$13(pomProgCommands, (SingleObserver)completeAction));
                    break;
                }
                LOGGER.info("No update of changed values required.");
                completeAction.onSuccess(null);
                break;
            }
            default: {
                LOGGER.info("Dialog was cancelled, stop the measurement.");
                this.updateProgressText("Adjusting speed values was cancelled.");
                this.fireMeasurementStop();
            }
        }
    }

    private void fireStop() {
        if (this.speedometerModel.isActive()) {
            LOGGER.info("Stop the measurement.");
            this.fireMeasurementStop();
        } else {
            LOGGER.info("Stop the car.");
            this.locoModel.setSpeed(Integer.valueOf(0));
        }
    }

    protected void fireMeasurementStop() {
        LOGGER.info("Stop the measurement.");
        this.fireToggleMeasure(false);
        ProgressStatusCallback callback = this.measurementProgressCallback;
        SwingUtilities.invokeLater(() -> {
            LOGGER.info("Stop the car.");
            this.fireStop();
            this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.ABORTED);
            CompositeDisposable compositeDisposable = this.speedometerModel.getCompositeDisposable();
            if (compositeDisposable != null) {
                LOGGER.info("Dispose the subscription on speed and battery message.");
                this.speedometerModel.setCompositeDisposable(null);
                compositeDisposable.dispose();
            }
            this.progressPanel.stop();
            if (callback != null) {
                LOGGER.info("Call actionFinished on callback to close the dialog.");
                callback.actionFinished();
            }
            this.speedoFunctionsEnabled.setValue((Object)true);
        });
    }

    private void fireStartAutoSpeedAdjustment() {
        MeasurementProgressDialog progressDialog = new MeasurementProgressDialog((Component)this.contentPanel, true, (MeasurementViewListener)new /* Unavailable Anonymous Inner Class!! */);
        this.measurementProgressDialogHolder.value = progressDialog;
        progressDialog.startAction();
    }

    private void scheduleStartAutoSpeedAdjustment() {
        int delay = 0;
        this.measurementWorker.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, (long)delay, TimeUnit.MILLISECONDS);
    }

    private void fireToggleMeasure(boolean activate) {
        LOGGER.info("Fire the measure, activate: {}", (Object)activate);
        if (activate) {
            this.speedometerModel.setActive(true);
            this.locoModel.setReportedSpeed(null);
            this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.MEASURE_ON);
        } else {
            if (!this.isMeasurementAborted()) {
                LOGGER.info("Set the measurement off.");
                this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.MEASURE_OFF);
            } else {
                LOGGER.info("Do not change the speed measurement stage because it is aborted.");
            }
            this.speedometerModel.setActive(false);
            this.measurementLed.setLedOn(false);
            if (this.speedometerProgBeanModel.getCv37Scale() == null) {
                SwingUtilities.invokeLater(() -> this.measureButton.setEnabled(false));
            }
        }
        SwingUtilities.invokeLater(() -> {
            this.measurementLed.setLedBlinking(activate);
            this.measureButton.setSelected(activate);
        });
    }

    private void fireAdjustCv2AndCv5(SpeedScaleBeanModel speedScaleBeanModel) {
        this.addLogText("Start adjusting CV2 and CV5.", new Object[0]);
        this.updateProgressText("Adjusting values for CV2 and CV5.");
        int delay = 0;
        this.measurementWorker.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, (long)delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean speedReadAndWriteCV(Function<Integer, Integer> speedConverter, int speedStep, int cvNumber, int waitForSpeedDelay) {
        this.fireSpeedStep(speedStep);
        try {
            this.addLogText("Wait {}s before get the current measured speed.", new Object[]{waitForSpeedDelay});
            Thread.sleep(waitForSpeedDelay * 1000);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for a stable speed measurement value at speed step {} failed.", (Object)speedStep, (Object)ex);
        }
        Integer currentSpeedValue = this.speedometerModel.getReportedSpeed();
        if (currentSpeedValue == null) {
            currentSpeedValue = 0;
        }
        Integer convertedSpeed = speedConverter.apply(currentSpeedValue);
        LOGGER.info("Current speed step {}, speed value: {}, convertedSpeed: {}", new Object[]{speedStep, currentSpeedValue, convertedSpeed});
        Object continueLock = new Object();
        27 completeAction = new /* Unavailable Anonymous Inner Class!! */;
        if (convertedSpeed > 255) {
            convertedSpeed = 255;
            LOGGER.info("Set the convertedSpeed to the upper limit value: {}", (Object)convertedSpeed);
        }
        LOGGER.info("Update the changed values, CV: {}, convertedSpeed: {}", (Object)cvNumber, (Object)convertedSpeed);
        this.updateProgressText("Set CV" + cvNumber + " to value: " + convertedSpeed);
        ArrayList<SpeedometerPomCommand> pomProgCommands = new ArrayList<SpeedometerPomCommand>();
        PomAddressData addressData = new PomAddressData(this.locoModel.getAddress().intValue(), PomAddressTypeEnum.LOCOMOTIVE);
        SpeedometerPomCommand command = new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, cvNumber, (int)ByteUtils.getLowByte((Integer)convertedSpeed).byteValue());
        command.setRetryCount(1);
        pomProgCommands.add(command);
        this.pomRequestProcessor.submitProgCommands(pomProgCommands, (SingleObserver)completeAction);
        Object object = continueLock;
        synchronized (object) {
            try {
                continueLock.wait(5000L);
            }
            catch (InterruptedException e1) {
                LOGGER.warn("Wait for signal continue lock was interrupted.", (Throwable)e1);
                this.fireMeasurementStop();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean speedValueAdjustmentLoop(BiFunction<Integer, Integer, Integer> speedConverter, Integer scaleValue, Integer currentCvValue, Integer currentCvRangeLimitValue, int cvNumber, int lowerRange, int upperRange, String progressTextPrefix) {
        boolean speedValueReached = false;
        while (!this.isMeasurementAborted()) {
            Integer n;
            Integer n2;
            try {
                this.addLogText("Wait 5s before compare speed value.", new Object[0]);
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Wait for a stable speed measurement value failed.", (Throwable)ex);
            }
            Integer currentSpeedValue = this.speedometerModel.getReportedSpeed();
            if (currentSpeedValue == null) {
                currentSpeedValue = 0;
            }
            Integer convertedSpeed = speedConverter.apply(currentSpeedValue, scaleValue);
            LOGGER.info("Current speed value: {}, convertedSpeed: {}, currentCvValue: {}", new Object[]{currentSpeedValue, convertedSpeed, currentCvValue});
            this.updateProgressText(progressTextPrefix + "<br>Current speed: " + convertedSpeed + " km/h");
            ArrayList<SpeedometerPomCommand> pomProgCommands = new ArrayList<SpeedometerPomCommand>();
            PomAddressData addressData = new PomAddressData(this.locoModel.getAddress().intValue(), PomAddressTypeEnum.LOCOMOTIVE);
            if (convertedSpeed < lowerRange) {
                n2 = currentCvValue;
                n = currentCvValue = Integer.valueOf(currentCvValue + 1);
                this.addLogText("Increase the CV{} value: {}", new Object[]{cvNumber, currentCvValue});
                pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, cvNumber, (int)ByteUtils.getLowByte((Integer)currentCvValue).byteValue()));
            } else if (convertedSpeed > upperRange) {
                if (convertedSpeed - upperRange > 5) {
                    currentCvValue = currentCvValue - 2;
                } else {
                    n2 = currentCvValue;
                    n = currentCvValue = Integer.valueOf(currentCvValue - 1);
                }
                this.addLogText("Decrease the CV{} value: {}", new Object[]{cvNumber, currentCvValue});
                pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, cvNumber, (int)ByteUtils.getLowByte((Integer)currentCvValue).byteValue()));
            } else {
                this.addLogText("Adjusted the CV{} value to target speed: {}", new Object[]{cvNumber, convertedSpeed});
            }
            Object continueLock = new Object();
            28 completeAction = new /* Unavailable Anonymous Inner Class!! */;
            if (CollectionUtils.isNotEmpty(pomProgCommands)) {
                LOGGER.info("Update the changed values.");
                this.pomRequestProcessor.submitProgCommands(pomProgCommands, (SingleObserver)completeAction);
                Object object = continueLock;
                synchronized (object) {
                    try {
                        continueLock.wait(5000L);
                    }
                    catch (InterruptedException e1) {
                        LOGGER.warn("Wait for signal continue lock was interrupted.", (Throwable)e1);
                        this.fireMeasurementStop();
                    }
                }
            }
            LOGGER.info("No update of changed values required.");
            speedValueReached = true;
            if (!speedValueReached) continue;
        }
        return speedValueReached;
    }

    private void fireSetPIDValues() {
        LOGGER.info("Set the PID values.");
        int result = 2;
        ApprovePidParamsDialog dialog = new ApprovePidParamsDialog(JOptionPane.getFrameForComponent(this.contentPanel), this.speedometerProgBeanModel);
        result = dialog.getResult();
        LOGGER.info("Result: {}", (Object)result);
        switch (result) {
            case 0: {
                PidParamsBeanModel pidParamsBeanModel = dialog.getPidParamsBeanModel();
                LOGGER.info("Write the PID values, pidParamsBeanModel: {}", (Object)pidParamsBeanModel);
                this.writeCvValues(pidParamsBeanModel, (SpeedometerProgBeanModel)this.speedometerProgProxyBeanModel, () -> {
                    LOGGER.info("Write CV values passed. Start the measurement.");
                    this.fireMeasurementStart();
                }, () -> {
                    LOGGER.warn("Write the PID values failed.");
                    this.fireMeasurementStop();
                });
                break;
            }
            default: {
                this.fireMeasurementStop();
            }
        }
    }

    protected void fireRestoreCv() {
        LOGGER.info("Write backup CV values.");
        LOGGER.info("Write CV values from backup model: {}", (Object)this.backupSpeedometerProgBeanModel);
        CvParamsBeanModel cvParamsBeanModel = new CvParamsBeanModel();
        cvParamsBeanModel.setCv2(this.backupSpeedometerProgBeanModel.getCv2Vmin());
        cvParamsBeanModel.setCv5(this.backupSpeedometerProgBeanModel.getCv5Vmax());
        cvParamsBeanModel.setCv35(this.backupSpeedometerProgBeanModel.getCv35());
        cvParamsBeanModel.setCv36(this.backupSpeedometerProgBeanModel.getCv36());
        this.writeCvValues((PidParamsBeanModel)cvParamsBeanModel, (SpeedometerProgBeanModel)this.speedometerProgProxyBeanModel, null, null);
    }

    protected void fireWriteCv() {
        LOGGER.info("Write CV values.");
        this.trigger.triggerCommit();
        LOGGER.info("Write CV values after trigger commit: {}", (Object)this.speedometerProgBeanModel);
        CvParamsBeanModel cvParamsBeanModel = new CvParamsBeanModel();
        cvParamsBeanModel.setCv2(this.speedometerProgBeanModel.getCv2Vmin());
        cvParamsBeanModel.setCv5(this.speedometerProgBeanModel.getCv5Vmax());
        cvParamsBeanModel.setCv37(this.speedometerProgBeanModel.getCv37Scale());
        cvParamsBeanModel.setCv61(this.speedometerProgBeanModel.getCv61());
        cvParamsBeanModel.setCv62(this.speedometerProgBeanModel.getCv62());
        cvParamsBeanModel.setCv63(this.speedometerProgBeanModel.getCv63());
        cvParamsBeanModel.setCv35(this.speedometerProgBeanModel.getCv35());
        cvParamsBeanModel.setCv36(this.speedometerProgBeanModel.getCv36());
        this.writeCvValues((PidParamsBeanModel)cvParamsBeanModel, (SpeedometerProgBeanModel)this.speedometerProgProxyBeanModel, null, null);
    }

    private void writeCvValues(PidParamsBeanModel pidParamsBeanModel, SpeedometerProgBeanModel speedoProgBeanModel, CallbackAction finishCallback, CallbackAction errorCallback) {
        ArrayList<SpeedometerPomCommand> pomProgCommands = new ArrayList<SpeedometerPomCommand>();
        PomAddressData addressData = new PomAddressData(this.locoModel.getAddress().intValue(), PomAddressTypeEnum.LOCOMOTIVE);
        if (pidParamsBeanModel instanceof CvParamsBeanModel) {
            CvParamsBeanModel cvParamsBeanModel = (CvParamsBeanModel)pidParamsBeanModel;
            if (!Objects.equals(cvParamsBeanModel.getCv2(), speedoProgBeanModel.getCv2Vmin())) {
                Integer cv2 = cvParamsBeanModel.getCv2();
                LOGGER.info("CV2 value has changed: {}", (Object)cv2);
                if (cv2 != null) {
                    pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 2, (int)ByteUtils.getLowByte((Integer)cv2).byteValue()));
                } else {
                    this.addLogText("No value for CV2 available.", new Object[0]);
                }
            }
            if (!Objects.equals(cvParamsBeanModel.getCv5(), speedoProgBeanModel.getCv5Vmax())) {
                Integer cv5 = cvParamsBeanModel.getCv5();
                LOGGER.info("CV5 value has changed: {}", (Object)cv5);
                if (cv5 != null) {
                    pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 5, (int)ByteUtils.getLowByte((Integer)cv5).byteValue()));
                } else {
                    this.addLogText("No value for CV5 available.", new Object[0]);
                }
            }
            if (!Objects.equals(cvParamsBeanModel.getCv35(), speedoProgBeanModel.getCv35())) {
                Integer cv35 = cvParamsBeanModel.getCv35();
                LOGGER.info("CV35 value has changed: {}", (Object)cv35);
                if (cv35 != null) {
                    pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 35, (int)ByteUtils.getLowByte((Integer)cv35).byteValue()));
                } else {
                    this.addLogText("No value for CV35 available.", new Object[0]);
                }
            }
            if (!Objects.equals(cvParamsBeanModel.getCv36(), speedoProgBeanModel.getCv36())) {
                Integer cv36 = cvParamsBeanModel.getCv36();
                LOGGER.info("CV36 value has changed: {}", (Object)cv36);
                if (cv36 != null) {
                    pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 36, (int)ByteUtils.getLowByte((Integer)cv36).byteValue()));
                } else {
                    this.addLogText("No value for CV36 available.", new Object[0]);
                }
            }
            if (!Objects.equals(cvParamsBeanModel.getCv37(), speedoProgBeanModel.getCv37Scale())) {
                Integer cv37 = cvParamsBeanModel.getCv37();
                LOGGER.info("CV37 value has changed: {}", (Object)cv37);
                if (cv37 != null) {
                    pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 37, (int)ByteUtils.getLowByte((Integer)cv37).byteValue()));
                } else {
                    this.addLogText("No value for CV37 available.", new Object[0]);
                }
            }
        }
        if (!Objects.equals(pidParamsBeanModel.getCv61(), speedoProgBeanModel.getCv61())) {
            Integer cv61 = pidParamsBeanModel.getCv61();
            LOGGER.info("CV61 value has changed: {}", (Object)cv61);
            if (cv61 != null) {
                pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 61, (int)ByteUtils.getLowByte((Integer)cv61).byteValue()));
            } else {
                this.addLogText("No value for CV61 available.", new Object[0]);
            }
        }
        if (!Objects.equals(pidParamsBeanModel.getCv62(), speedoProgBeanModel.getCv62())) {
            Integer cv62 = pidParamsBeanModel.getCv62();
            LOGGER.info("CV62 value has changed: {}", (Object)cv62);
            if (cv62 != null) {
                pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 62, (int)ByteUtils.getLowByte((Integer)cv62).byteValue()));
            } else {
                this.addLogText("No value for CV62 available.", new Object[0]);
            }
        }
        if (!Objects.equals(pidParamsBeanModel.getCv63(), speedoProgBeanModel.getCv63())) {
            Integer cv63 = pidParamsBeanModel.getCv63();
            LOGGER.info("CV63 value has changed: {}", (Object)cv63);
            if (cv63 != null) {
                pomProgCommands.add(new SpeedometerPomCommand(addressData, PomOperation.WR_BYTE, 63, (int)ByteUtils.getLowByte((Integer)cv63).byteValue()));
            } else {
                this.addLogText("No value for CV63 available.", new Object[0]);
            }
        }
        29 completeAction = new /* Unavailable Anonymous Inner Class!! */;
        if (CollectionUtils.isNotEmpty(pomProgCommands)) {
            LOGGER.info("Update the changed PID values.");
            this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.IDLE);
            this.speedometerModel.setPomProgCommands(pomProgCommands);
            this.speedometerModel.setCompleteAction((SingleObserver)completeAction);
            this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.WRITE_CV_VALUES);
        } else {
            LOGGER.info("No update of changed values required.");
            completeAction.onSuccess(null);
        }
    }

    private void fireMeasurementStart() {
        this.speedometerModel.setCv37Scale(this.speedometerProgBeanModel.getCv37Scale());
        this.addLogText("Start the measurement.", new Object[0]);
        this.speedometerModel.setSpeedMeasurementStage(SpeedometerModel.SpeedMeasurementStage.START_MEASUREMENT);
    }

    private void fireSpeedStep(int speedStep) {
        LOGGER.info("Set the speedStep: {}", (Object)speedStep);
        if (SwingUtilities.isEventDispatchThread()) {
            this.locoModel.setSpeed(Integer.valueOf(speedStep));
        } else {
            SwingUtilities.invokeLater(() -> this.locoModel.setSpeed(Integer.valueOf(speedStep)));
        }
    }

    private void signalPomProgStateChanged(PomProgState pomProgState) {
        LOGGER.info("The POM prog state has changed: {}", (Object)pomProgState);
        switch (30.$SwitchMap$org$bidib$jbidibc$messages$enums$PomProgState[pomProgState.ordinal()]) {
            case 1: {
                this.currentOperationLabel.setIcon(this.progOperationSuccessfulIcon);
                this.addLogText("Prog operation passed: " + this.getCurrentOperation(), new Object[0]);
                this.enableInputElements();
                break;
            }
            case 2: 
            case 3: {
                this.currentOperationLabel.setIcon(this.progOperationErrorIcon);
                this.addLogText("Prog operation failed: {}", new Object[]{pomProgState.name()});
                this.enableInputElements();
                break;
            }
            case 4: {
                this.currentOperationLabel.setIcon(this.progOperationUnknownIcon);
                this.addLogText("Prog operation started: " + this.getCurrentOperation(), new Object[0]);
                break;
            }
            case 5: {
                this.currentOperationLabel.setIcon(this.progOperationWaitIcon);
                this.addLogText("Prog operation is running ...", new Object[0]);
            }
        }
    }

    protected void disableInputElements() {
        LOGGER.trace("Disable input elements.");
    }

    protected void enableInputElements() {
        LOGGER.trace("Enable input elements.");
    }

    private Object getCurrentOperation() {
        return this.speedometerProgProxyBeanModel.getCurrentOperation();
    }

    protected void fireReadCv() {
        LOGGER.info("Read CV values without show the dialog.");
        this.fireReadCvValues(null);
    }

    public void close() {
        LOGGER.info("Close the panel.");
        LOGGER.info("Shutdown the measurementWorker.");
        this.measurementWorker.shutdownNow();
    }

    private /* synthetic */ void lambda$validateVMinAndScaleValue$13(List pomProgCommands, SingleObserver completeAction) {
        this.pomRequestProcessor.submitProgCommands(pomProgCommands, completeAction);
    }
}

