/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Component;
import java.awt.event.ComponentListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BacklightPortValueListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.client.common.model.listener.PortTableLayoutListener;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.PortAwareNumberRenderer;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.mvc.common.view.editor.DmxChannelCellEditor;
import org.bidib.wizard.mvc.common.view.editor.NumberRangeEditor;
import org.bidib.wizard.mvc.main.controller.BacklightPortPanelController;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.BacklightPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.BacklightPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightPortListPanel
extends SimpleHierarchicalPortListPanel<BacklightPortTableModel, BacklightPortStatus, BacklightPort, BacklightPortValueListener, BacklightPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator,
PortTableLayoutListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortListPanel.class);
    private final MainModel mainModel;
    private final AtomicBoolean isDmxNode = new AtomicBoolean(true);
    private final TabVisibilityListener tabVisibilityListener;

    public BacklightPortListPanel(BacklightPortPanelController controller, BacklightPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super((SimpleHierarchicalPortTableModel)tableModel, Resources.getString(BacklightPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, (NodeSelectionProvider)mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    protected AbstractPortHierarchicalTable<BacklightPort> createPortTable(BacklightPortTableModel tableModel, String emptyTableText) {
        return new BacklightPortTable(tableModel, emptyTableText);
    }

    protected void createTable(BacklightPortTableModel tableModel, String emptyTableText, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable((SimpleHierarchicalPortTableModel)tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table, nodeSelectionProvider, null);
        this.table.setPortListMenuListener(portListMenuListener);
        this.addComponentListener((ComponentListener)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "left");
        this.table.getActionMap().put("left", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "right");
        this.table.getActionMap().put("right", (Action)new /* Unavailable Anonymous Inner Class!! */);
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof BacklightPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected void processListChanged() {
        super.processListChanged();
        this.tabVisibilityListener.setTabVisible((Component)this, this.isTabVisible());
        this.portTableLayoutChanged();
    }

    public void portTableLayoutChanged() {
        if (TableColumnChooser.isVisibleColumn((JTable)this.table, (int)3)) {
            NodeInterface node = this.mainModel.getSelectedNode();
            LOGGER.info("The DMX column is visible for node: {}", (Object)node);
            if (node != null) {
                boolean newNodeIsDmxNode = ProductUtils.isOneDMX((long)node.getUniqueId());
                if (newNodeIsDmxNode != this.isDmxNode.get()) {
                    LOGGER.info("The DMX support of node has changed, newNodeIsDmxNode: {}", (Object)newNodeIsDmxNode);
                    this.isDmxNode.set(newNodeIsDmxNode);
                    TableColumn tcDmxMapping = this.table.getColumnModel().getColumn(3);
                    if (newNodeIsDmxNode) {
                        tcDmxMapping.setCellRenderer((TableCellRenderer)new DmxChannelRenderer());
                        tcDmxMapping.setCellEditor((TableCellEditor)new DmxChannelCellEditor(1, 256));
                        tcDmxMapping.setHeaderValue(Resources.getString(BacklightPortTableModel.class, (String)"dmxMapping"));
                    } else {
                        tcDmxMapping.setCellRenderer((TableCellRenderer)new PortAwareNumberRenderer());
                        tcDmxMapping.setCellEditor((TableCellEditor)new NumberRangeEditor(0, 255));
                        tcDmxMapping.setHeaderValue(Resources.getString(BacklightPortTableModel.class, (String)"channel"));
                    }
                    JTableHeader th = this.table.getTableHeader();
                    th.repaint();
                } else {
                    LOGGER.info("The DMX column is visible but the isDmxNode property has not changed: {}", (Object)this.isDmxNode);
                }
            }
        } else {
            LOGGER.info("The DMX column is not visible.");
        }
    }

    public Class<?> getPortClass() {
        return BacklightPort.class;
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasBacklightPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    protected List<BacklightPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            return node.getBacklightPorts();
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

