/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.view.panel.DirectAccessProgBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvWritePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvWritePanel.class);
    private final JCheckBox[] checkBitValues = new JCheckBox[8];
    private final JRadioButton[] radioBitValues = new JRadioButton[8];
    private JPanel byteValuePanel;
    private JPanel bitValuePanel;
    private final PtProgrammerModel programmerModel;
    private final DirectAccessProgBeanModel cvModel;
    private CardLayout cardLayout;
    private boolean lockUpdate;
    private JPanel panel;
    private static final String ENCODED_COLUMN_SPECS_BYTE = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow";
    private static final String ENCODED_ROW_SPECS_BYTE = "p";
    private static final String ENCODED_COLUMN_SPECS_BIT = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow";
    private static final String ENCODED_ROW_SPECS_BIT = "p";

    public CvWritePanel(PtProgrammerModel model, DirectAccessProgBeanModel cvModel) {
        this.programmerModel = model;
        this.cvModel = cvModel;
    }

    public JPanel createPanel() {
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.cardLayout = new CardLayout();
        this.panel.setLayout(this.cardLayout);
        this.panel.add((Component)this.prepareByteValuePanel(), "byte");
        this.panel.add((Component)this.prepareBitValuePanel(), "bit");
        this.cvModel.addPropertyChangeListener("mode", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.panel;
    }

    private JPanel prepareByteValuePanel() {
        FormBuilder pbuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow", new Object[0]).rows("p", new Object[0]).panel(new JPanel());
        int column = 1;
        for (int bit = 7; bit >= 0; --bit) {
            this.checkBitValues[bit] = new JCheckBox(String.valueOf(bit), false);
            this.checkBitValues[bit].setContentAreaFilled(false);
            this.checkBitValues[bit].addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
            pbuilder.add((Component)this.checkBitValues[bit]).xy(column, 1);
            column += 2;
        }
        this.byteValuePanel = pbuilder.getPanel();
        return this.byteValuePanel;
    }

    private JPanel prepareBitValuePanel() {
        FormBuilder pbuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow", new Object[0]).rows("p", new Object[0]).panel(new JPanel());
        ButtonGroup group = new ButtonGroup();
        int column = 1;
        for (int bit = 7; bit >= 0; --bit) {
            this.radioBitValues[bit] = new JRadioButton(String.valueOf(bit), false);
            this.radioBitValues[bit].setContentAreaFilled(false);
            group.add(this.radioBitValues[bit]);
            pbuilder.add((Component)this.radioBitValues[bit]).xy(column, 1);
            column += 2;
        }
        this.bitValuePanel = pbuilder.getPanel();
        return this.bitValuePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByteValue(Object cvValue) {
        LOGGER.info("Update the byte value: {}", cvValue);
        if (cvValue == null) {
            cvValue = "0";
        }
        try {
            String bitValue = Integer.toBinaryString(Integer.parseInt(cvValue.toString()));
            this.lockUpdate = true;
            for (int index = 0; index < this.checkBitValues.length; ++index) {
                if (index < bitValue.length()) {
                    this.checkBitValues[index].setSelected(bitValue.charAt(bitValue.length() - index - 1) == '1');
                    continue;
                }
                this.checkBitValues[index].setSelected(false);
            }
        }
        catch (NumberFormatException ex) {
            for (int index = 0; index < this.checkBitValues.length; ++index) {
                this.checkBitValues[index].setSelected(false);
            }
        }
        finally {
            this.lockUpdate = false;
        }
    }

    public int getSelectedBit() {
        byte val = 0;
        for (int bit = this.radioBitValues.length - 1; bit >= 0; --bit) {
            if (!this.radioBitValues[bit].isSelected()) continue;
            val = (byte)bit;
            break;
        }
        LOGGER.info("Prepared bitValue: {}", (Object)ByteUtils.byteToHex((byte)val));
        return ByteUtils.getInt((byte)val);
    }

    public void setEnabled(boolean enabled) {
        this.panel.setEnabled(enabled);
        if (enabled) {
            DisabledPanel.enable((Container)this.bitValuePanel);
            DisabledPanel.enable((Container)this.byteValuePanel);
        } else {
            DisabledPanel.disable((Container)this.bitValuePanel);
            DisabledPanel.disable((Container)this.byteValuePanel);
        }
    }
}

