package org.bidib.wizard.mvc.position.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.model.PositionAddressData;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;

public class FeedbackPositionTableCellRenderer implements TableCellRenderer {

    private JPanel panel;

    private DisabledPanel disabledInnerPanel;

    private int timeout = 5000;

    public FeedbackPositionTableCellRenderer() {
        panel = new JPanel(new GridBagLayout());
        panel.setOpaque(true);

        disabledInnerPanel = createInnerPanel();
    }

    /**
     * Set the timeout value in milliseconds that is used to show the port as outdated (orange background).
     * 
     * @param timeout
     *            timeout value in milliseconds
     */
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        // clear the panel
        panel.removeAll();

        if (value instanceof PositionFeedbackPort) {
            PositionFeedbackPort port = (PositionFeedbackPort) value;

            FeedbackPortStatus status = port.getStatus();

            Collection<PositionAddressData> addresses = port.getAddresses();

            // prepare the port label
            String label = null;

            if (StringUtils.isNotBlank(port.getLabel())) {
                label = String.format("%1$02d : %2$s", port.getId(), port.getLabel());
            }
            else if (port.getId() > -1) {
                label = String.format("%1$02d", port.getId());
            }
            else {
                label = " ";
            }
            portLabel.setText(label);

            addressPanel.removeAll();

            // boolean outdated = false;
            if (addresses != null) {
                for (PositionAddressData address : addresses) {
                    addressPanel.add(new JLabel(getAddressData(address)));
                    // if (isOutDated(address.getLastSeenTimestamp(), System.currentTimeMillis())) {
                    // outdated = true;
                    // }
                }
            }

            // background color
            if (status == FeedbackPortStatus.OCCUPIED) {
                if (!port.isOutdated(timeout)) {
                    innerPanel.setBackground(Color.RED);
                }
                else {
                    innerPanel.setBackground(Color.ORANGE);
                }
            }
            else {
                innerPanel.setBackground(Color.GREEN);
            }

            boolean enabled = true;

            disabledInnerPanel.setEnabled(enabled);

            GridBagConstraints c = new GridBagConstraints();
            c.fill = GridBagConstraints.BOTH;
            c.weightx = 1;
            c.weighty = 1;
            panel.add(disabledInnerPanel, c);
        }
        return panel;
    }

    // private boolean isOutDated(long timestamp, long now) {
    // return (now - timestamp) > timeout;
    // }

    private JPanel innerPanel;

    private JLabel portLabel;

    private JLabel confidenceLabel;

    private JPanel addressPanel;

    private JLabel dynStateLabel;

    private JLabel timestampLabel;

    private DisabledPanel createInnerPanel() {

        innerPanel = new JPanel(new GridBagLayout());

        GridBagConstraints c = new GridBagConstraints();

        c.anchor = GridBagConstraints.CENTER;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1;

        // prepare the port label
        portLabel = new JLabel();
        Font f = portLabel.getFont();

        portLabel.setFont(f.deriveFont(f.getStyle() | Font.BOLD));
        innerPanel.add(portLabel, c);

        c.gridy++;
        confidenceLabel = new JLabel();
        innerPanel.add(confidenceLabel, c);

        addressPanel = new JPanel();
        addressPanel.setOpaque(false);
        addressPanel.setLayout(new BoxLayout(addressPanel, BoxLayout.PAGE_AXIS));
        c.gridy++;
        innerPanel.add(addressPanel, c);

        dynStateLabel = new JLabel();
        c.gridy++;
        innerPanel.add(dynStateLabel, c);

        timestampLabel = new JLabel();
        c.gridy++;
        innerPanel.add(timestampLabel, c);

        c.fill = GridBagConstraints.BOTH;
        c.gridy++;
        c.weighty = 1;
        innerPanel.add(Box.createVerticalGlue(), c);

        // gray out depending on confidence
        DisabledPanel disabledInnerPanel = new DisabledPanel(innerPanel);

        c.gridy = 0;
        panel.add(disabledInnerPanel, c);

        return disabledInnerPanel;
    }

    private String getAddressData(PositionAddressData address) {
        StringBuilder result = new StringBuilder();

        if (address != null) {
            if (result.length() > 0) {
                result.append(',');
            }
            int addr = address.getDecoderAddress();
            result.append(addr);
            // result.append('(');
            // result.append(address.getSpeed());
            // result.append(')');

        }
        else {
            result.append("[]");
        }
        return result.toString();
    }
}
