package org.bidib.wizard.mvc.stepcontrol.view.wizard;

import javax.swing.JLabel;
import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class SummaryPanel extends AbstractWizardPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SummaryPanel.class);

    private ConfigurationWizardModel configurationWizardModel;

    public SummaryPanel(JWizardComponents wizardComponents, final ConfigurationWizardModel configurationWizardModel) {
        super(wizardComponents);

        this.configurationWizardModel = configurationWizardModel;
    }

    @Override
    protected void initPanel() {
        super.initPanel();

        // prepare the form
        boolean debug = false;
        FormBuilder builder =
            FormBuilder
                .create().columns("p, 3dlu, p:g").rows("p, 3dlu, p").panel(debug ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.TABBED_DIALOG);

        builder.add(Resources.getString(getClass(), "message")).xyw(1, 1, 3);

        // html content
        ValueModel htmlContentValueModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_HTMLCONTENT, true);
        JLabel htmlContentLabel = WizardComponentFactory.createLabel(htmlContentValueModel);
        builder.add(htmlContentLabel).xyw(1, 3, 3);

        // build the panel
        this.panel = builder.build();
    }

    @Override
    public void update() {
        LOGGER.info("update is called.");
        super.update();

        configurationWizardModel.triggerUpdateHtmlContent();
        // updateGearingComponents();
    }
}
