/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.controller.actions;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import javax.swing.JOptionPane;
import org.bidib.wizard.api.event.WizardUpdateWorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.worklist.controller.ActionAbortedException;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadWizardAction
implements WorkListAction<WizardUpdateWorkListItemEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadWizardAction.class);

    public void apply(DockingDesktop desktop, WizardUpdateWorkListItemEvent actionEvent) throws ActionAbortedException {
        LOGGER.info("Let the wizard update service download the new installer.");
        String downloadUrl = actionEvent.getDownloadUrl();
        int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()), Resources.getString(DownloadWizardAction.class, (String)"download-new-installer.text", (Object[])new Object[]{downloadUrl}), Resources.getString(DownloadWizardAction.class, (String)"download-new-installer.title"), 2);
        if (result == 0) {
            LOGGER.info("Download the new installer to the local directory: {}", (Object)downloadUrl);
            try {
                Desktop.getDesktop().browse(URI.create(downloadUrl));
            }
            catch (IOException ex) {
                LOGGER.warn("Download the new installer to the local directory failed.", (Throwable)ex);
                throw new ActionAbortedException("Download the new installer to the local directory failed.");
            }
        } else {
            LOGGER.info("Download the new installer to the local directory was cancelled.");
            throw new ActionAbortedException("Download the new installer to the local directory was cancelled.");
        }
    }
}

