package org.bidib.wizard.mvc.accessory.view.panel;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.accessory.model.AccessoryBeanModel;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.util.PropertyValidationSupport;

public class DccExtAccessoryPanel extends AbstractAccessoryPanel<AccessoryBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DccExtAccessoryPanel.class);

    private static final String ENCODED_LOCAL_COLUMN_SPECS =
        "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref:grow";

    private static final String ENCODED_LOCAL_ROW_SPECS = "pref";

    private final AccessoryBeanModel accessoryBeanModel;

    private JButton aspectButtons[];

    public DccExtAccessoryPanel(final AccessoryModel accessoryModel) {
        super(accessoryModel);
        accessoryBeanModel = new AccessoryBeanModel();
    }

    @Override
    protected AccessoryBeanModel getAccessoryBeanModel() {
        return accessoryBeanModel;
    }

    @Override
    protected void addSpecificComponents(final FormBuilder builder, final int[] rowHolder) {
        // goto next line
        // builder.nextLine();

        FormBuilder localBuilder =
            FormBuilder.create().columns(ENCODED_LOCAL_COLUMN_SPECS).rows(ENCODED_LOCAL_ROW_SPECS);
        // add the aspects
        aspectButtons = new JButton[3];
        int column = 1;
        for (int aspect = 0; aspect < 3; aspect++) {

            JButton aspectButton = new JButton(new AbstractAction("Aspect " + aspect) {
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    // set aspect button was pressed
                    Integer aspect = (Integer) ((JButton) e.getSource()).getClientProperty("aspect");
                    LOGGER.info("Pressed button: {}, aspect: {}", e.getActionCommand(), aspect);

                    addLogText("Send DCC accessory request, address: {}, aspect: {}, switch time: {}, time base: {}",
                        accessoryBeanModel.getDccAddress(), aspect, accessoryBeanModel.getSwitchTime(),
                        Resources.getString(TimeBaseUnitEnum.class, accessoryBeanModel.getTimeBaseUnit().getKey()));

                    // set the aspect triggers the property change listener
                    accessoryBeanModel.setAcknowledge(null);
                    accessoryBeanModel.setAspect(aspect);
                    // send the request
                    AddressData addressData =
                        new AddressData(accessoryBeanModel.getDccAddress(), AddressTypeEnum.EXTENDED_ACCESSORY);
                    sendRequest(addressData, accessoryBeanModel.getAspect(), accessoryBeanModel.getSwitchTime(),
                        accessoryBeanModel.getTimeBaseUnit(), TimingControlEnum.COIL_ON_OFF);
                }
            });
            aspectButton.putClientProperty("aspect", Integer.valueOf(aspect));
            aspectButton.setEnabled(false);
            aspectButtons[aspect] = aspectButton;
            localBuilder.add(aspectButton).xy(column, 1);

            column += 2;
        }

        int row = rowHolder[0];
        row += 2;
        builder.appendRows("3dlu, p");

        builder.add(localBuilder.build()).xyw(1, row, 9);

        // update the row holder
        rowHolder[0] = row;
    }

    @Override
    protected void addSpecificValidation() {

        // if the model is valid, the aspect buttons are enabled.
        for (int aspect = aspectButtons.length - 1; aspect > -1; aspect--) {
            PropertyConnector
                .connect(accessoryValidationModel, AccessoryValidationResultModel.PROPERTY_VALID_STATE,
                    aspectButtons[aspect], "enabled");
        }
    }

    @Override
    protected void validateSpecificPanel(PropertyValidationSupport support) {

    }

    private static final int MAX_ADDRESS = 511;

    @Override
    protected int getMaxAddress() {
        return MAX_ADDRESS;
    }
}
